/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.boot.origin.TextResourceOrigin;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.PathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class ConfigTreePropertySource
extends EnumerablePropertySource<Path>
implements OriginLookup<String> {
    private static final int MAX_DEPTH = 100;
    private final Map<String, PropertyFile> propertyFiles;
    private final String[] names;
    private final Set<Option> options;

    public ConfigTreePropertySource(String name, Path sourceDirectory) {
        this(name, sourceDirectory, EnumSet.noneOf(Option.class));
    }

    public ConfigTreePropertySource(String name, Path sourceDirectory, Option ... options) {
        this(name, sourceDirectory, EnumSet.copyOf(Arrays.asList(options)));
    }

    private ConfigTreePropertySource(String name, Path sourceDirectory, Set<Option> options) {
        super(name, (Object)sourceDirectory);
        Assert.isTrue((boolean)Files.exists(sourceDirectory, new LinkOption[0]), () -> "Directory '" + sourceDirectory + "' does not exist");
        Assert.isTrue((boolean)Files.isDirectory(sourceDirectory, new LinkOption[0]), () -> "File '" + sourceDirectory + "' is not a directory");
        this.propertyFiles = PropertyFile.findAll(sourceDirectory, options);
        this.options = options;
        this.names = StringUtils.toStringArray(this.propertyFiles.keySet());
    }

    public String[] getPropertyNames() {
        return (String[])this.names.clone();
    }

    public Value getProperty(String name) {
        PropertyFile propertyFile = this.propertyFiles.get(name);
        return propertyFile != null ? propertyFile.getContent() : null;
    }

    @Override
    public Origin getOrigin(String name) {
        PropertyFile propertyFile = this.propertyFiles.get(name);
        return propertyFile != null ? propertyFile.getOrigin() : null;
    }

    @Override
    public boolean isImmutable() {
        return !this.options.contains((Object)Option.ALWAYS_READ);
    }

    private static final class PropertyFileContent
    implements Value,
    OriginProvider {
        private final Path path;
        private final Resource resource;
        private final boolean cacheContent;
        private volatile byte[] content;
        private final Origin origin;

        private PropertyFileContent(Path path, Resource resource, Origin origin, boolean cacheContent) {
            this.path = path;
            this.resource = resource;
            this.origin = origin;
            this.cacheContent = cacheContent;
        }

        @Override
        public Origin getOrigin() {
            return this.origin;
        }

        @Override
        public int length() {
            return this.toString().length();
        }

        @Override
        public char charAt(int index) {
            return this.toString().charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().subSequence(start, end);
        }

        @Override
        public String toString() {
            return new String(this.getBytes());
        }

        public InputStream getInputStream() throws IOException {
            if (!this.cacheContent) {
                this.assertStillExists();
                return this.resource.getInputStream();
            }
            return new ByteArrayInputStream(this.getBytes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getBytes() {
            try {
                if (!this.cacheContent) {
                    this.assertStillExists();
                    return FileCopyUtils.copyToByteArray((InputStream)this.resource.getInputStream());
                }
                if (this.content == null) {
                    this.assertStillExists();
                    Resource resource = this.resource;
                    synchronized (resource) {
                        if (this.content == null) {
                            this.content = FileCopyUtils.copyToByteArray((InputStream)this.resource.getInputStream());
                        }
                    }
                }
                return this.content;
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private void assertStillExists() {
            Assert.state((boolean)Files.exists(this.path, new LinkOption[0]), () -> "The property file '" + this.path + "' no longer exists");
        }
    }

    private static final class PropertyFile {
        private static final TextResourceOrigin.Location START_OF_FILE = new TextResourceOrigin.Location(0, 0);
        private final Path path;
        private final PathResource resource;
        private final Origin origin;
        private final PropertyFileContent cachedContent;

        private PropertyFile(Path path, Set<Option> options) {
            this.path = path;
            this.resource = new PathResource(path);
            this.origin = new TextResourceOrigin((Resource)this.resource, START_OF_FILE);
            this.cachedContent = options.contains((Object)Option.ALWAYS_READ) ? null : new PropertyFileContent(path, (Resource)this.resource, this.origin, true);
        }

        PropertyFileContent getContent() {
            return this.cachedContent != null ? this.cachedContent : new PropertyFileContent(this.path, (Resource)this.resource, this.origin, false);
        }

        Origin getOrigin() {
            return this.origin;
        }

        static Map<String, PropertyFile> findAll(Path sourceDirectory, Set<Option> options) {
            try {
                TreeMap propertyFiles = new TreeMap();
                Files.find(sourceDirectory, 100, PropertyFile::isRegularFile, new FileVisitOption[0]).forEach(path -> {
                    String name = PropertyFile.getName(sourceDirectory.relativize((Path)path));
                    if (StringUtils.hasText((String)name)) {
                        if (options.contains((Object)Option.USE_LOWERCASE_NAMES)) {
                            name = name.toLowerCase();
                        }
                        propertyFiles.put(name, new PropertyFile((Path)path, options));
                    }
                });
                return Collections.unmodifiableMap(propertyFiles);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to find files in '" + sourceDirectory + "'", ex);
            }
        }

        private static boolean isRegularFile(Path path, BasicFileAttributes attributes) {
            return attributes.isRegularFile();
        }

        private static String getName(Path relativePath) {
            int nameCount = relativePath.getNameCount();
            if (nameCount == 1) {
                return relativePath.toString();
            }
            StringBuilder name = new StringBuilder();
            for (int i = 0; i < nameCount; ++i) {
                name.append(i != 0 ? "." : "");
                name.append(relativePath.getName(i));
            }
            return name.toString();
        }
    }

    public static interface Value
    extends CharSequence,
    InputStreamSource {
    }

    public static enum Option {
        ALWAYS_READ,
        USE_LOWERCASE_NAMES;

    }
}

