/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBeanRegistrar;
import org.springframework.boot.context.properties.ImportAsConfigurationPropertiesBean;
import org.springframework.boot.context.properties.ImportAsConfigurationPropertiesBeans;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class ImportAsConfigurationPropertiesBeanRegistrar
implements ImportBeanDefinitionRegistrar {
    ImportAsConfigurationPropertiesBeanRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry, BeanNameGenerator importBeanNameGenerator) {
        try {
            ConfigurationPropertiesBeanRegistrar registrar = new ConfigurationPropertiesBeanRegistrar(registry);
            MergedAnnotations annotations = importingClassMetadata.getAnnotations();
            this.registerBeans(registrar, (MergedAnnotation<ImportAsConfigurationPropertiesBeans>)annotations.get(ImportAsConfigurationPropertiesBeans.class));
            this.registerBean(registrar, (MergedAnnotation<ImportAsConfigurationPropertiesBean>)annotations.get(ImportAsConfigurationPropertiesBean.class));
        }
        catch (RuntimeException ex) {
            throw new IllegalStateException("Unable process @ImportAsConfigurationPropertiesBean annotations from " + importingClassMetadata.getClassName(), ex);
        }
    }

    private void registerBeans(ConfigurationPropertiesBeanRegistrar registrar, MergedAnnotation<ImportAsConfigurationPropertiesBeans> annotation) {
        if (!annotation.isPresent()) {
            return;
        }
        for (MergedAnnotation containedAnnotation : annotation.getAnnotationArray("value", ImportAsConfigurationPropertiesBean.class)) {
            this.registerBean(registrar, (MergedAnnotation<ImportAsConfigurationPropertiesBean>)containedAnnotation);
        }
    }

    private void registerBean(ConfigurationPropertiesBeanRegistrar registrar, MergedAnnotation<ImportAsConfigurationPropertiesBean> annotation) {
        if (!annotation.isPresent()) {
            return;
        }
        Object[] types = annotation.getClassArray("type");
        Assert.state((!ObjectUtils.isEmpty((Object[])types) ? 1 : 0) != 0, (String)"@ImportAsConfigurationPropertiesBean must declare types to import");
        MergedAnnotation configurationPropertiesAnnotation = MergedAnnotations.from((Annotation[])new Annotation[]{annotation.synthesize()}).get(ConfigurationProperties.class);
        for (Object type : types) {
            registrar.register((Class<?>)type, (MergedAnnotation<ConfigurationProperties>)configurationPropertiesAnnotation, true);
        }
    }
}

