/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBean;
import org.springframework.boot.context.properties.ConfigurationPropertiesBeanDefinition;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindException;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinder;
import org.springframework.core.annotation.MergedAnnotation;

final class ConfigurationPropertiesValueObjectBeanDefinition
extends ConfigurationPropertiesBeanDefinition {
    private final BeanFactory beanFactory;
    private final String beanName;
    private final boolean deduceBindConstructor;

    ConfigurationPropertiesValueObjectBeanDefinition(BeanFactory beanFactory, String beanName, Class<?> beanClass, MergedAnnotation<ConfigurationProperties> annotation, boolean deduceBindConstructor) {
        super(beanClass, annotation);
        this.beanFactory = beanFactory;
        this.beanName = beanName;
        this.deduceBindConstructor = deduceBindConstructor;
        this.setInstanceSupplier(this::createBean);
    }

    boolean isDeduceBindConstructor() {
        return this.deduceBindConstructor;
    }

    private Object createBean() {
        ConfigurationPropertiesBean bean = ConfigurationPropertiesBean.forValueObject(this.getBeanClass(), this.beanName, ConfigurationPropertiesValueObjectBeanDefinition.getAnnotation((BeanDefinition)this), this.deduceBindConstructor);
        ConfigurationPropertiesBinder binder = ConfigurationPropertiesBinder.get(this.beanFactory);
        try {
            return binder.bindOrCreate(bean);
        }
        catch (Exception ex) {
            throw new ConfigurationPropertiesBindException(bean, ex);
        }
    }
}

