/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBean;
import org.springframework.boot.context.properties.ConfigurationPropertiesBeanDefinition;
import org.springframework.boot.context.properties.ConfigurationPropertiesValueObjectBeanDefinition;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class ConfigurationPropertiesBeanRegistrar {
    private final BeanDefinitionRegistry registry;
    private final BeanFactory beanFactory;

    ConfigurationPropertiesBeanRegistrar(BeanDefinitionRegistry registry) {
        this.registry = registry;
        this.beanFactory = (BeanFactory)this.registry;
    }

    void register(Class<?> type, MergedAnnotation<ConfigurationProperties> annotation, boolean deduceBindConstructor) {
        MergedAnnotation typeAnnotation = MergedAnnotations.from(type, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(ConfigurationProperties.class);
        annotation = !typeAnnotation.isPresent() ? annotation : typeAnnotation;
        String name = this.getName(type, (MergedAnnotation<ConfigurationProperties>)(annotation = annotation != null ? annotation : MergedAnnotation.missing()));
        if (!this.containsBeanDefinition(name)) {
            this.registerBeanDefinition(name, type, (MergedAnnotation<ConfigurationProperties>)annotation, deduceBindConstructor);
        }
    }

    private String getName(Class<?> type, MergedAnnotation<ConfigurationProperties> annotation) {
        String prefix = annotation.isPresent() ? annotation.getString("prefix") : "";
        return StringUtils.hasText((String)prefix) ? prefix + "-" + type.getName() : type.getName();
    }

    private boolean containsBeanDefinition(String name) {
        return this.containsBeanDefinition(this.beanFactory, name);
    }

    private boolean containsBeanDefinition(BeanFactory beanFactory, String name) {
        if (beanFactory instanceof ListableBeanFactory && ((ListableBeanFactory)beanFactory).containsBeanDefinition(name)) {
            return true;
        }
        if (beanFactory instanceof HierarchicalBeanFactory) {
            return this.containsBeanDefinition(((HierarchicalBeanFactory)beanFactory).getParentBeanFactory(), name);
        }
        return false;
    }

    private void registerBeanDefinition(String beanName, Class<?> type, MergedAnnotation<ConfigurationProperties> annotation, boolean deduceBindConstructor) {
        Assert.state((boolean)annotation.isPresent(), () -> "No " + ConfigurationProperties.class.getSimpleName() + " annotation found on  '" + type.getName() + "'.");
        this.registry.registerBeanDefinition(beanName, this.createBeanDefinition(beanName, type, annotation, deduceBindConstructor));
    }

    private BeanDefinition createBeanDefinition(String beanName, Class<?> type, MergedAnnotation<ConfigurationProperties> annotation, boolean deduceBindConstructor) {
        if (ConfigurationPropertiesBean.BindMethod.forType(type, deduceBindConstructor) == ConfigurationPropertiesBean.BindMethod.VALUE_OBJECT) {
            return new ConfigurationPropertiesValueObjectBeanDefinition(this.beanFactory, beanName, type, annotation, deduceBindConstructor);
        }
        return new ConfigurationPropertiesBeanDefinition(type, annotation);
    }
}

