/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.config.ConfigDataActivationContext;
import org.springframework.boot.context.config.InvalidConfigDataPropertyException;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.BoundPropertiesTrackingBindHandler;
import org.springframework.boot.context.properties.bind.Name;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.origin.Origin;
import org.springframework.util.ObjectUtils;

class ConfigDataProperties {
    private static final ConfigurationPropertyName NAME = ConfigurationPropertyName.of("spring.config");
    private static final ConfigurationPropertyName IMPORT_NAME = ConfigurationPropertyName.of("spring.config.import");
    private static final ConfigurationPropertyName LEGACY_PROFILES_NAME = ConfigurationPropertyName.of("spring.profiles");
    private static final Bindable<ConfigDataProperties> BINDABLE_PROPERTIES = Bindable.of(ConfigDataProperties.class);
    private static final Bindable<String[]> BINDABLE_STRING_ARRAY = Bindable.of(String[].class);
    private final List<String> imports;
    private final Activate activate;
    private final Map<ConfigurationPropertyName, ConfigurationProperty> boundProperties;

    ConfigDataProperties(@Name(value="import") List<String> imports, Activate activate) {
        this(imports, activate, Collections.emptyList());
    }

    private ConfigDataProperties(List<String> imports, Activate activate, List<ConfigurationProperty> boundProperties) {
        this.imports = imports != null ? imports : Collections.emptyList();
        this.activate = activate;
        this.boundProperties = this.mapByName(boundProperties);
    }

    private Map<ConfigurationPropertyName, ConfigurationProperty> mapByName(List<ConfigurationProperty> boundProperties) {
        LinkedHashMap result = new LinkedHashMap();
        boundProperties.forEach(property -> result.put(property.getName(), property));
        return Collections.unmodifiableMap(result);
    }

    List<String> getImports() {
        return this.imports;
    }

    Origin getImportOrigin(String importLocation) {
        int index = this.imports.indexOf(importLocation);
        if (index == -1) {
            return null;
        }
        ConfigurationProperty bound = this.boundProperties.get(IMPORT_NAME.append("[" + index + "]"));
        bound = bound != null ? bound : this.boundProperties.get(IMPORT_NAME);
        return bound != null ? bound.getOrigin() : null;
    }

    boolean isActive(ConfigDataActivationContext activationContext) {
        return this.activate == null || this.activate.isActive(activationContext);
    }

    ConfigDataProperties withoutImports() {
        return new ConfigDataProperties(null, this.activate);
    }

    ConfigDataProperties withLegacyProfiles(String[] legacyProfiles, ConfigurationProperty property) {
        if (this.activate != null && !ObjectUtils.isEmpty((Object[])this.activate.onProfile)) {
            throw new InvalidConfigDataPropertyException(property, NAME.append("activate.on-profile"), null);
        }
        return new ConfigDataProperties(this.imports, new Activate(this.activate.onCloudPlatform, legacyProfiles));
    }

    ConfigDataProperties withBoundProperties(List<ConfigurationProperty> boundProperties) {
        return new ConfigDataProperties(this.imports, this.activate, boundProperties);
    }

    static ConfigDataProperties get(Binder binder) {
        LegacyProfilesBindHandler legacyProfilesBindHandler = new LegacyProfilesBindHandler();
        Object[] legacyProfiles = binder.bind(LEGACY_PROFILES_NAME, BINDABLE_STRING_ARRAY, (BindHandler)legacyProfilesBindHandler).orElse(null);
        ArrayList<ConfigurationProperty> boundProperties = new ArrayList<ConfigurationProperty>();
        ConfigDataProperties properties = binder.bind(NAME, BINDABLE_PROPERTIES, (BindHandler)new BoundPropertiesTrackingBindHandler(boundProperties::add)).orElse(null);
        if (!ObjectUtils.isEmpty((Object[])legacyProfiles)) {
            properties = properties != null ? properties.withLegacyProfiles((String[])legacyProfiles, legacyProfilesBindHandler.getProperty()) : new ConfigDataProperties(null, new Activate(null, (String[])legacyProfiles));
        }
        return properties != null ? properties.withBoundProperties(boundProperties) : null;
    }

    static class Activate {
        private final CloudPlatform onCloudPlatform;
        private final String[] onProfile;

        Activate(CloudPlatform onCloudPlatform, String[] onProfile) {
            this.onProfile = onProfile;
            this.onCloudPlatform = onCloudPlatform;
        }

        boolean isActive(ConfigDataActivationContext activationContext) {
            if (activationContext == null) {
                return false;
            }
            boolean activate = true;
            activate = activate && this.isActive(activationContext.getCloudPlatform());
            activate = activate && this.isActive(activationContext.getProfiles());
            return activate;
        }

        private boolean isActive(CloudPlatform cloudPlatform) {
            return this.onCloudPlatform == null || this.onCloudPlatform == cloudPlatform;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean isActive(Profiles profiles) {
            if (ObjectUtils.isEmpty((Object[])this.onProfile)) return true;
            if (profiles == null) return false;
            if (!this.matchesActiveProfiles(profiles::isAccepted)) return false;
            return true;
        }

        private boolean matchesActiveProfiles(Predicate<String> activeProfiles) {
            return org.springframework.core.env.Profiles.of((String[])this.onProfile).matches(activeProfiles);
        }
    }

    private static class LegacyProfilesBindHandler
    implements BindHandler {
        private ConfigurationProperty property;

        private LegacyProfilesBindHandler() {
        }

        @Override
        public Object onSuccess(ConfigurationPropertyName name, Bindable<?> target, BindContext context, Object result) {
            this.property = context.getConfigurationProperty();
            return result;
        }

        ConfigurationProperty getProperty() {
            return this.property;
        }
    }
}

