/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundAction;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.OptionalConfigDataLocation;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.config.ResourceConfigDataLocationResolver;
import org.springframework.boot.context.config.UnsupportedConfigDataLocationException;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.boot.util.Instantiator;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.log.LogMessage;
import org.springframework.util.StringUtils;

class ConfigDataLocationResolvers {
    private final Log logger;
    private final ConfigDataLocationNotFoundAction locationNotFoundAction;
    private final List<ConfigDataLocationResolver<?>> resolvers;

    ConfigDataLocationResolvers(DeferredLogFactory logFactory, ConfigurableBootstrapContext bootstrapContext, ConfigDataLocationNotFoundAction locationNotFoundAction, Binder binder, ResourceLoader resourceLoader) {
        this(logFactory, bootstrapContext, locationNotFoundAction, binder, resourceLoader, SpringFactoriesLoader.loadFactoryNames(ConfigDataLocationResolver.class, null));
    }

    ConfigDataLocationResolvers(DeferredLogFactory logFactory, ConfigurableBootstrapContext bootstrapContext, ConfigDataLocationNotFoundAction locationNotFoundAction, Binder binder, ResourceLoader resourceLoader, List<String> names) {
        this.logger = logFactory.getLog(this.getClass());
        this.locationNotFoundAction = locationNotFoundAction;
        Instantiator instantiator = new Instantiator(ConfigDataLocationResolver.class, availableParameters -> {
            availableParameters.add(Log.class, logFactory::getLog);
            availableParameters.add(Binder.class, binder);
            availableParameters.add(ResourceLoader.class, resourceLoader);
            availableParameters.add(ConfigurableBootstrapContext.class, bootstrapContext);
            availableParameters.add(BootstrapContext.class, bootstrapContext);
            availableParameters.add(BootstrapRegistry.class, bootstrapContext);
        });
        this.resolvers = this.reorder(instantiator.instantiate(names));
    }

    private List<ConfigDataLocationResolver<?>> reorder(List<ConfigDataLocationResolver<?>> resolvers) {
        ArrayList reordered = new ArrayList(resolvers.size());
        ResourceConfigDataLocationResolver resourceResolver = null;
        for (ConfigDataLocationResolver<?> resolver : resolvers) {
            if (resolver instanceof ResourceConfigDataLocationResolver) {
                resourceResolver = (ResourceConfigDataLocationResolver)resolver;
                continue;
            }
            reordered.add(resolver);
        }
        if (resourceResolver != null) {
            reordered.add(resourceResolver);
        }
        return Collections.unmodifiableList(reordered);
    }

    List<ConfigDataLocation> resolveAll(ConfigDataLocationResolverContext context, List<String> locations, Profiles profiles) {
        ArrayList<ConfigDataLocation> resolved = new ArrayList<ConfigDataLocation>(locations.size());
        for (String location : locations) {
            resolved.addAll(this.resolveAll(context, location, profiles));
        }
        return resolved;
    }

    private List<ConfigDataLocation> resolveAll(ConfigDataLocationResolverContext context, String location, Profiles profiles) {
        boolean optional = location != null && location.startsWith("optional:");
        String string = location = !optional ? location : location.substring("optional:".length());
        if (!StringUtils.hasText((String)location)) {
            return Collections.emptyList();
        }
        for (ConfigDataLocationResolver<?> resolver : this.getResolvers()) {
            if (!resolver.isResolvable(context, location)) continue;
            return this.resolve(resolver, context, optional, location, profiles);
        }
        throw new UnsupportedConfigDataLocationException(location);
    }

    private List<ConfigDataLocation> resolve(ConfigDataLocationResolver<?> resolver, ConfigDataLocationResolverContext context, boolean optional, String location, Profiles profiles) {
        List<ConfigDataLocation> resolved = this.resolve(location, optional, () -> resolver.resolve(context, location, optional));
        if (profiles == null) {
            return resolved;
        }
        List<ConfigDataLocation> profileSpecific = this.resolve(location, optional, () -> resolver.resolveProfileSpecific(context, location, optional, profiles));
        return this.merge(resolved, profileSpecific);
    }

    private List<ConfigDataLocation> resolve(String location, boolean optional, Supplier<List<? extends ConfigDataLocation>> resolveAction) {
        try {
            List<ConfigDataLocation> resolved = this.nonNullList(resolveAction.get());
            if (!resolved.isEmpty() && optional) {
                resolved = OptionalConfigDataLocation.wrapAll(resolved);
            }
            return resolved;
        }
        catch (ConfigDataLocationNotFoundException ex) {
            if (optional) {
                this.logger.trace((Object)LogMessage.format((String)"Skipping missing resource from optional location %s", (Object)location));
                return Collections.emptyList();
            }
            this.locationNotFoundAction.handle(this.logger, location, ex);
            return Collections.emptyList();
        }
    }

    private <T> List<T> nonNullList(List<? extends T> list) {
        return list != null ? list : Collections.emptyList();
    }

    private <T> List<T> merge(List<T> list1, List<T> list2) {
        ArrayList<T> merged = new ArrayList<T>(list1.size() + list2.size());
        merged.addAll(list1);
        merged.addAll(list2);
        return merged;
    }

    List<ConfigDataLocationResolver<?>> getResolvers() {
        return this.resolvers;
    }
}

