/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.springframework.boot.context.config.ConfigDataException;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.core.io.Resource;

public class ConfigDataLocationNotFoundException
extends ConfigDataException {
    private final ConfigDataLocation location;

    public ConfigDataLocationNotFoundException(ConfigDataLocation location) {
        this(location, null);
    }

    public ConfigDataLocationNotFoundException(ConfigDataLocation location, Throwable cause) {
        this(ConfigDataLocationNotFoundException.getMessage(location), location, cause);
    }

    public ConfigDataLocationNotFoundException(String message, ConfigDataLocation location) {
        this(message, location, null);
    }

    public ConfigDataLocationNotFoundException(String message, ConfigDataLocation location, Throwable cause) {
        super(message, cause);
        this.location = location;
    }

    public ConfigDataLocation getLocation() {
        return this.location;
    }

    private static String getMessage(ConfigDataLocation location) {
        return "Config data location '" + location + "' does not exist";
    }

    public static void throwIfDoesNotExist(ConfigDataLocation location, Path path) {
        ConfigDataLocationNotFoundException.throwIfDoesNotExist(location, Files.exists(path, new LinkOption[0]));
    }

    public static void throwIfDoesNotExist(ConfigDataLocation location, File file) {
        ConfigDataLocationNotFoundException.throwIfDoesNotExist(location, file.exists());
    }

    public static void throwIfDoesNotExist(ConfigDataLocation location, Resource resource) {
        ConfigDataLocationNotFoundException.throwIfDoesNotExist(location, resource.exists());
    }

    private static void throwIfDoesNotExist(ConfigDataLocation location, boolean exists) {
        if (!exists) {
            throw new ConfigDataLocationNotFoundException(location);
        }
    }
}

