/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundAction;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.OptionalConfigDataLocation;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.boot.util.Instantiator;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;

class ConfigDataLoaders {
    private final Log logger;
    private final ConfigDataLocationNotFoundAction locationNotFoundAction;
    private final List<ConfigDataLoader<?>> loaders;
    private final List<Class<?>> locationTypes;

    ConfigDataLoaders(DeferredLogFactory logFactory, ConfigurableBootstrapContext bootstrapContext, ConfigDataLocationNotFoundAction locationNotFoundAction) {
        this(logFactory, bootstrapContext, locationNotFoundAction, SpringFactoriesLoader.loadFactoryNames(ConfigDataLoader.class, null));
    }

    ConfigDataLoaders(DeferredLogFactory logFactory, ConfigurableBootstrapContext bootstrapContext, ConfigDataLocationNotFoundAction locationNotFoundAction, List<String> names) {
        this.logger = logFactory.getLog(this.getClass());
        this.locationNotFoundAction = locationNotFoundAction;
        Instantiator instantiator = new Instantiator(ConfigDataLoader.class, availableParameters -> {
            availableParameters.add(Log.class, logFactory::getLog);
            availableParameters.add(ConfigurableBootstrapContext.class, bootstrapContext);
            availableParameters.add(BootstrapContext.class, bootstrapContext);
            availableParameters.add(BootstrapRegistry.class, bootstrapContext);
        });
        this.loaders = instantiator.instantiate(names);
        this.locationTypes = this.getLocationTypes(this.loaders);
    }

    private List<Class<?>> getLocationTypes(List<ConfigDataLoader<?>> loaders) {
        ArrayList locationTypes = new ArrayList(loaders.size());
        for (ConfigDataLoader<?> loader : loaders) {
            locationTypes.add(this.getLocationType(loader));
        }
        return Collections.unmodifiableList(locationTypes);
    }

    private Class<?> getLocationType(ConfigDataLoader<?> loader) {
        return ResolvableType.forClass(loader.getClass()).as(ConfigDataLoader.class).resolveGeneric(new int[0]);
    }

    <L extends ConfigDataLocation> ConfigData load(ConfigDataLoaderContext context, L location) throws IOException {
        boolean optional = location instanceof OptionalConfigDataLocation;
        location = !optional ? location : OptionalConfigDataLocation.unwrap(location);
        return this.load(context, optional, location);
    }

    private <L extends ConfigDataLocation> ConfigData load(ConfigDataLoaderContext context, boolean optional, L location) throws IOException {
        ConfigDataLoader loader = this.getLoader(context, location);
        this.logger.trace((Object)LogMessage.of(() -> "Loading " + location + " using loader " + loader.getClass().getName()));
        try {
            return loader.load(context, location);
        }
        catch (ConfigDataLocationNotFoundException ex) {
            if (optional) {
                this.logger.trace((Object)LogMessage.format((String)"Skipping missing resource from optional location %s", location));
                return null;
            }
            this.locationNotFoundAction.handle(this.logger, location, ex);
            return null;
        }
    }

    private <L extends ConfigDataLocation> ConfigDataLoader<L> getLoader(ConfigDataLoaderContext context, L location) {
        ConfigDataLoader<?> result = null;
        for (int i = 0; i < this.loaders.size(); ++i) {
            ConfigDataLoader<?> loader;
            ConfigDataLoader<?> candidate = this.loaders.get(i);
            if (!this.locationTypes.get(i).isInstance(location) || !(loader = candidate).isLoadable(context, location)) continue;
            if (result != null) {
                throw new IllegalStateException("Multiple loaders found for location " + location + " [" + candidate.getClass().getName() + "," + result.getClass().getName() + "]");
            }
            result = loader;
        }
        Assert.state((result != null ? 1 : 0) != 0, () -> "No loader found for location '" + location + "'");
        return result;
    }
}

