/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.DefaultPropertiesPropertySource;
import org.springframework.boot.context.config.ConfigDataActivationContext;
import org.springframework.boot.context.config.ConfigDataEnvironmentContributor;
import org.springframework.boot.context.config.ConfigDataEnvironmentContributorPlaceholdersResolver;
import org.springframework.boot.context.config.ConfigDataEnvironmentContributors;
import org.springframework.boot.context.config.ConfigDataImporter;
import org.springframework.boot.context.config.ConfigDataLoaders;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundAction;
import org.springframework.boot.context.config.ConfigDataLocationResolvers;
import org.springframework.boot.context.config.InactiveConfigDataAccessException;
import org.springframework.boot.context.config.InvalidConfigDataPropertyException;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.config.UseLegacyConfigProcessingException;
import org.springframework.boot.context.properties.bind.BindException;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.log.LogMessage;
import org.springframework.util.StringUtils;

class ConfigDataEnvironment {
    static final String LOCATION_PROPERTY = "spring.config.location";
    static final String ADDITIONAL_LOCATION_PROPERTY = "spring.config.additional-location";
    static final String IMPORT_PROPERTY = "spring.config.import";
    static final String ON_LOCATION_NOT_FOUND_PROPERTY = "spring.config.on-location-not-found";
    static final String[] DEFAULT_SEARCH_LOCATIONS = new String[]{"optional:classpath:/", "optional:classpath:/config/", "optional:file:./", "optional:file:./config/*/", "optional:file:./config/"};
    private static final String[] EMPTY_LOCATIONS = new String[0];
    private static final ConfigurationPropertyName INCLUDE_PROFILES = ConfigurationPropertyName.of("spring.profiles.include");
    private static final Bindable<List<String>> STRING_LIST = Bindable.listOf(String.class);
    private final DeferredLogFactory logFactory;
    private final Log logger;
    private final ConfigurableBootstrapContext bootstrapContext;
    private final ConfigurableEnvironment environment;
    private final ConfigDataLocationResolvers resolvers;
    private final Collection<String> additionalProfiles;
    private final ConfigDataLoaders loaders;
    private final ConfigDataEnvironmentContributors contributors;

    ConfigDataEnvironment(DeferredLogFactory logFactory, ConfigurableBootstrapContext bootstrapContext, ConfigurableEnvironment environment, ResourceLoader resourceLoader, Collection<String> additionalProfiles) {
        Binder binder = Binder.get((Environment)environment);
        UseLegacyConfigProcessingException.throwIfRequested(binder);
        ConfigDataLocationNotFoundAction locationNotFoundAction = binder.bind(ON_LOCATION_NOT_FOUND_PROPERTY, ConfigDataLocationNotFoundAction.class).orElse(ConfigDataLocationNotFoundAction.FAIL);
        this.logFactory = logFactory;
        this.logger = logFactory.getLog(this.getClass());
        this.bootstrapContext = bootstrapContext;
        this.environment = environment;
        this.resolvers = this.createConfigDataLocationResolvers(logFactory, bootstrapContext, locationNotFoundAction, binder, resourceLoader);
        this.additionalProfiles = additionalProfiles;
        this.loaders = new ConfigDataLoaders(logFactory, bootstrapContext, locationNotFoundAction);
        this.contributors = this.createContributors(binder);
    }

    protected ConfigDataLocationResolvers createConfigDataLocationResolvers(DeferredLogFactory logFactory, ConfigurableBootstrapContext bootstrapContext, ConfigDataLocationNotFoundAction locationNotFoundAction, Binder binder, ResourceLoader resourceLoader) {
        return new ConfigDataLocationResolvers(logFactory, bootstrapContext, locationNotFoundAction, binder, resourceLoader);
    }

    private ConfigDataEnvironmentContributors createContributors(Binder binder) {
        this.logger.trace((Object)"Building config data environment contributors");
        MutablePropertySources propertySources = this.environment.getPropertySources();
        ArrayList<ConfigDataEnvironmentContributor> contributors = new ArrayList<ConfigDataEnvironmentContributor>(propertySources.size() + 10);
        PropertySource defaultPropertySource = null;
        for (PropertySource propertySource : propertySources) {
            if (DefaultPropertiesPropertySource.hasMatchingName(propertySource)) {
                defaultPropertySource = propertySource;
                continue;
            }
            this.logger.trace((Object)LogMessage.format((String)"Creating wrapped config data contributor for '%s'", (Object)propertySource.getName()));
            contributors.add(ConfigDataEnvironmentContributor.ofExisting(propertySource));
        }
        contributors.addAll(this.getInitialImportContributors(binder));
        if (defaultPropertySource != null) {
            this.logger.trace((Object)"Creating wrapped config data contributor for default property source");
            contributors.add(ConfigDataEnvironmentContributor.ofExisting(defaultPropertySource));
        }
        return new ConfigDataEnvironmentContributors(this.logFactory, this.bootstrapContext, contributors);
    }

    ConfigDataEnvironmentContributors getContributors() {
        return this.contributors;
    }

    private List<ConfigDataEnvironmentContributor> getInitialImportContributors(Binder binder) {
        ArrayList<ConfigDataEnvironmentContributor> initialContributors = new ArrayList<ConfigDataEnvironmentContributor>();
        this.addInitialImportContributors(initialContributors, binder.bind(IMPORT_PROPERTY, String[].class).orElse(EMPTY_LOCATIONS));
        this.addInitialImportContributors(initialContributors, binder.bind(ADDITIONAL_LOCATION_PROPERTY, String[].class).orElse(EMPTY_LOCATIONS));
        this.addInitialImportContributors(initialContributors, binder.bind(LOCATION_PROPERTY, String[].class).orElse(DEFAULT_SEARCH_LOCATIONS));
        return initialContributors;
    }

    private void addInitialImportContributors(List<ConfigDataEnvironmentContributor> initialContributors, String[] locations) {
        for (int i = locations.length - 1; i >= 0; --i) {
            initialContributors.add(this.createInitialImportContributor(locations[i]));
        }
    }

    private ConfigDataEnvironmentContributor createInitialImportContributor(String location) {
        this.logger.trace((Object)LogMessage.format((String)"Adding initial config data import from location '%s'", (Object)location));
        return ConfigDataEnvironmentContributor.ofInitialImport(location);
    }

    void processAndApply() {
        ConfigDataImporter importer = new ConfigDataImporter(this.resolvers, this.loaders);
        this.bootstrapContext.register(Binder.class, BootstrapRegistry.InstanceSupplier.from(() -> this.contributors.getBinder(null, ConfigDataEnvironmentContributors.BinderOption.FAIL_ON_BIND_TO_INACTIVE_SOURCE)));
        ConfigDataEnvironmentContributors contributors = this.processInitial(this.contributors, importer);
        Binder initialBinder = contributors.getBinder(null, ConfigDataEnvironmentContributors.BinderOption.FAIL_ON_BIND_TO_INACTIVE_SOURCE);
        this.bootstrapContext.register(Binder.class, BootstrapRegistry.InstanceSupplier.of(initialBinder));
        ConfigDataActivationContext activationContext = this.createActivationContext(initialBinder);
        contributors = this.processWithoutProfiles(contributors, importer, activationContext);
        activationContext = this.withProfiles(contributors, activationContext);
        contributors = this.processWithProfiles(contributors, importer, activationContext);
        this.applyToEnvironment(contributors, activationContext);
    }

    private ConfigDataEnvironmentContributors processInitial(ConfigDataEnvironmentContributors contributors, ConfigDataImporter importer) {
        this.logger.trace((Object)"Processing initial config data environment contributors without activation context");
        return contributors.withProcessedImports(importer, null);
    }

    private ConfigDataActivationContext createActivationContext(Binder initialBinder) {
        this.logger.trace((Object)"Creating config data activation context from initial contributions");
        try {
            return new ConfigDataActivationContext((Environment)this.environment, initialBinder);
        }
        catch (BindException ex) {
            if (ex.getCause() instanceof InactiveConfigDataAccessException) {
                throw (InactiveConfigDataAccessException)ex.getCause();
            }
            throw ex;
        }
    }

    private ConfigDataEnvironmentContributors processWithoutProfiles(ConfigDataEnvironmentContributors contributors, ConfigDataImporter importer, ConfigDataActivationContext activationContext) {
        this.logger.trace((Object)"Processing config data environment contributors with initial activation context");
        return contributors.withProcessedImports(importer, activationContext);
    }

    private ConfigDataActivationContext withProfiles(ConfigDataEnvironmentContributors contributors, ConfigDataActivationContext activationContext) {
        this.logger.trace((Object)"Deducing profiles from current config data environment contributors");
        Binder binder = contributors.getBinder(activationContext, ConfigDataEnvironmentContributors.BinderOption.FAIL_ON_BIND_TO_INACTIVE_SOURCE);
        try {
            LinkedHashSet<String> additionalProfiles = new LinkedHashSet<String>(this.additionalProfiles);
            additionalProfiles.addAll(this.getIncludedProfiles(contributors, activationContext));
            Profiles profiles = new Profiles((Environment)this.environment, binder, additionalProfiles);
            return activationContext.withProfiles(profiles);
        }
        catch (BindException ex) {
            if (ex.getCause() instanceof InactiveConfigDataAccessException) {
                throw (InactiveConfigDataAccessException)ex.getCause();
            }
            throw ex;
        }
    }

    private Collection<? extends String> getIncludedProfiles(ConfigDataEnvironmentContributors contributors, ConfigDataActivationContext activationContext) {
        ConfigDataEnvironmentContributorPlaceholdersResolver placeholdersResolver = new ConfigDataEnvironmentContributorPlaceholdersResolver(contributors, activationContext, true);
        LinkedHashSet result = new LinkedHashSet();
        for (ConfigDataEnvironmentContributor contributor : contributors) {
            ConfigurationPropertySource source = contributor.getConfigurationPropertySource();
            if (source == null) continue;
            Binder binder = new Binder(Collections.singleton(source), placeholdersResolver);
            binder.bind(INCLUDE_PROFILES, STRING_LIST).ifBound(includes -> {
                if (!contributor.isActive(activationContext)) {
                    InactiveConfigDataAccessException.throwIfPropertyFound(contributor, INCLUDE_PROFILES);
                }
                result.addAll(includes);
            });
        }
        return result;
    }

    private ConfigDataEnvironmentContributors processWithProfiles(ConfigDataEnvironmentContributors contributors, ConfigDataImporter importer, ConfigDataActivationContext activationContext) {
        this.logger.trace((Object)"Processing config data environment contributors with profile activation context");
        return contributors.withProcessedImports(importer, activationContext);
    }

    private void applyToEnvironment(ConfigDataEnvironmentContributors contributors, ConfigDataActivationContext activationContext) {
        this.checkForInvalidProperties(contributors);
        MutablePropertySources propertySources = this.environment.getPropertySources();
        this.logger.trace((Object)"Applying config data environment contributions");
        for (ConfigDataEnvironmentContributor contributor : contributors) {
            if (contributor.getKind() != ConfigDataEnvironmentContributor.Kind.BOUND_IMPORT || contributor.getPropertySource() == null) continue;
            if (!contributor.isActive(activationContext)) {
                this.logger.trace((Object)LogMessage.format((String)"Skipping inactive property source '%s'", (Object)contributor.getPropertySource().getName()));
                continue;
            }
            this.logger.trace((Object)LogMessage.format((String)"Adding imported property source '%s'", (Object)contributor.getPropertySource().getName()));
            propertySources.addLast(contributor.getPropertySource());
        }
        DefaultPropertiesPropertySource.moveToEnd(propertySources);
        Profiles profiles = activationContext.getProfiles();
        this.logger.trace((Object)LogMessage.format((String)"Setting default profiles: %s", profiles.getDefault()));
        this.environment.setDefaultProfiles(StringUtils.toStringArray(profiles.getDefault()));
        this.logger.trace((Object)LogMessage.format((String)"Setting active profiles: %s", profiles.getActive()));
        this.environment.setActiveProfiles(StringUtils.toStringArray(profiles.getActive()));
    }

    private void checkForInvalidProperties(ConfigDataEnvironmentContributors contributors) {
        for (ConfigDataEnvironmentContributor contributor : contributors) {
            InvalidConfigDataPropertyException.throwOrWarn(this.logger, contributor);
        }
    }
}

