/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.EnvironmentPostProcessorsFactory;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class ReflectionEnvironmentPostProcessorsFactory
implements EnvironmentPostProcessorsFactory {
    private final List<String> classNames;

    ReflectionEnvironmentPostProcessorsFactory(Class<?> ... classes) {
        this((String[])Arrays.stream(classes).map(Class::getName).toArray(String[]::new));
    }

    ReflectionEnvironmentPostProcessorsFactory(String ... classNames) {
        this(Arrays.asList(classNames));
    }

    ReflectionEnvironmentPostProcessorsFactory(List<String> classNames) {
        this.classNames = classNames;
    }

    @Override
    public List<EnvironmentPostProcessor> getEnvironmentPostProcessors(DeferredLogFactory logFactory) {
        ArrayList<EnvironmentPostProcessor> postProcessors = new ArrayList<EnvironmentPostProcessor>(this.classNames.size());
        for (String className : this.classNames) {
            try {
                postProcessors.add(this.getEnvironmentPostProcessor(className, logFactory));
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Unable to instantiate factory class [" + className + "] for factory type [" + EnvironmentPostProcessor.class.getName() + "]", ex);
            }
        }
        AnnotationAwareOrderComparator.sort(postProcessors);
        return postProcessors;
    }

    private EnvironmentPostProcessor getEnvironmentPostProcessor(String className, DeferredLogFactory logFactory) throws Exception {
        Constructor<?>[] constructors;
        Class type = ClassUtils.forName((String)className, (ClassLoader)this.getClass().getClassLoader());
        Assert.isAssignable(EnvironmentPostProcessor.class, (Class)type);
        for (Constructor<?> constructor : constructors = type.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != 1) continue;
            Class<?> cls = constructor.getParameterTypes()[0];
            if (DeferredLogFactory.class.isAssignableFrom(cls)) {
                return this.newInstance(constructor, logFactory);
            }
            if (!Log.class.isAssignableFrom(cls)) continue;
            return this.newInstance(constructor, logFactory.getLog(type));
        }
        return (EnvironmentPostProcessor)ReflectionUtils.accessibleConstructor((Class)type, (Class[])new Class[0]).newInstance(new Object[0]);
    }

    private EnvironmentPostProcessor newInstance(Constructor<?> constructor, Object ... initargs) throws Exception {
        ReflectionUtils.makeAccessible(constructor);
        return (EnvironmentPostProcessor)constructor.newInstance(initargs);
    }
}

