/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.ReflectionEnvironmentPostProcessorsFactory;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.io.support.SpringFactoriesLoader;

@FunctionalInterface
public interface EnvironmentPostProcessorsFactory {
    public List<EnvironmentPostProcessor> getEnvironmentPostProcessors(DeferredLogFactory var1);

    public static EnvironmentPostProcessorsFactory fromSpringFactories(ClassLoader classLoader) {
        return new ReflectionEnvironmentPostProcessorsFactory(SpringFactoriesLoader.loadFactoryNames(EnvironmentPostProcessor.class, (ClassLoader)classLoader));
    }

    public static EnvironmentPostProcessorsFactory of(Class<?> ... classes) {
        return new ReflectionEnvironmentPostProcessorsFactory(classes);
    }

    public static EnvironmentPostProcessorsFactory of(String ... classNames) {
        return new ReflectionEnvironmentPostProcessorsFactory(classNames);
    }

    public static EnvironmentPostProcessorsFactory singleton(Function<DeferredLogFactory, EnvironmentPostProcessor> factory) {
        return logFactory -> Collections.singletonList(factory.apply(logFactory));
    }
}

