/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.EnvironmentPostProcessorsFactory;
import org.springframework.boot.logging.DeferredLogs;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class EnvironmentPostProcessorApplicationListener
implements SmartApplicationListener,
Ordered {
    public static final int DEFAULT_ORDER = -2147483638;
    private final DeferredLogs deferredLogs;
    private int order = -2147483638;
    private final EnvironmentPostProcessorsFactory postProcessorsFactory;

    public EnvironmentPostProcessorApplicationListener() {
        this(EnvironmentPostProcessorsFactory.fromSpringFactories(EnvironmentPostProcessorApplicationListener.class.getClassLoader()));
    }

    public EnvironmentPostProcessorApplicationListener(EnvironmentPostProcessorsFactory postProcessorsFactory) {
        this(postProcessorsFactory, new DeferredLogs());
    }

    EnvironmentPostProcessorApplicationListener(EnvironmentPostProcessorsFactory postProcessorsFactory, DeferredLogs deferredLogs) {
        this.postProcessorsFactory = postProcessorsFactory;
        this.deferredLogs = deferredLogs;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ApplicationEnvironmentPreparedEvent.class.isAssignableFrom(eventType) || ApplicationPreparedEvent.class.isAssignableFrom(eventType) || ApplicationFailedEvent.class.isAssignableFrom(eventType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            this.onApplicationEnvironmentPreparedEvent((ApplicationEnvironmentPreparedEvent)event);
        }
        if (event instanceof ApplicationPreparedEvent || event instanceof ApplicationFailedEvent) {
            this.onFinish();
        }
    }

    private void onApplicationEnvironmentPreparedEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        SpringApplication application = event.getSpringApplication();
        for (EnvironmentPostProcessor postProcessor : this.getEnvironmentPostProcessors()) {
            postProcessor.postProcessEnvironment(environment, application);
        }
    }

    List<EnvironmentPostProcessor> getEnvironmentPostProcessors() {
        return this.postProcessorsFactory.getEnvironmentPostProcessors(this.deferredLogs);
    }

    private void onFinish() {
        this.deferredLogs.switchOverAll();
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

