/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.util.Map;
import java.util.function.Consumer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;

public class DefaultPropertiesPropertySource
extends MapPropertySource {
    public static final String NAME = "defaultProperties";

    public DefaultPropertiesPropertySource(Map<String, Object> source) {
        super(NAME, source);
    }

    public static boolean hasMatchingName(PropertySource<?> propertySource) {
        return propertySource != null && propertySource.getName().equals(NAME);
    }

    public static void ifNotEmpty(Map<String, Object> source, Consumer<DefaultPropertiesPropertySource> action) {
        if (!CollectionUtils.isEmpty(source) && action != null) {
            action.accept(new DefaultPropertiesPropertySource(source));
        }
    }

    public static void moveToEnd(ConfigurableEnvironment environment) {
        DefaultPropertiesPropertySource.moveToEnd(environment.getPropertySources());
    }

    public static void moveToEnd(MutablePropertySources propertySources) {
        PropertySource propertySource = propertySources.remove(NAME);
        if (propertySource != null) {
            propertySources.addLast(propertySource);
        }
    }
}

