/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.config.ResourceConfigDataLocation;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.Ordered;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

class ResourceConfigDataLocationResolver
implements ConfigDataLocationResolver<ResourceConfigDataLocation>,
Ordered {
    private static final String PREFIX = "resource:";
    static final String CONFIG_NAME_PROPERTY = "spring.config.name";
    private static final String[] DEFAULT_CONFIG_NAMES = new String[]{"application"};
    private static final Resource[] EMPTY_RESOURCES = new Resource[0];
    private static final Comparator<File> FILE_COMPARATOR = Comparator.comparing(File::getAbsolutePath);
    private static final Pattern URL_PREFIX = Pattern.compile("^([a-zA-Z][a-zA-Z0-9*]*?:)(.*$)");
    private static final String NO_PROFILE = null;
    private final Log logger;
    private final List<PropertySourceLoader> propertySourceLoaders;
    private final String[] configNames;
    private final ResourceLoader resourceLoader;

    ResourceConfigDataLocationResolver(Log logger, Binder binder, ResourceLoader resourceLoader) {
        this.logger = logger;
        this.propertySourceLoaders = SpringFactoriesLoader.loadFactories(PropertySourceLoader.class, (ClassLoader)this.getClass().getClassLoader());
        this.configNames = this.getConfigNames(binder);
        this.resourceLoader = resourceLoader;
    }

    private String[] getConfigNames(Binder binder) {
        String[] configNames;
        for (String configName : configNames = binder.bind(CONFIG_NAME_PROPERTY, String[].class).orElse(DEFAULT_CONFIG_NAMES)) {
            this.validateConfigName(configName);
        }
        return configNames;
    }

    private void validateConfigName(String name) {
        Assert.state((!name.contains("*") ? 1 : 0) != 0, () -> "Config name '" + name + "' cannot contain '*'");
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isResolvable(ConfigDataLocationResolverContext context, String location) {
        return true;
    }

    @Override
    public List<ResourceConfigDataLocation> resolve(ConfigDataLocationResolverContext context, String location) {
        return this.resolve(location, this.getResolvables(context, location));
    }

    @Override
    public List<ResourceConfigDataLocation> resolveProfileSpecific(ConfigDataLocationResolverContext context, String location, Profiles profiles) {
        return this.resolve(location, this.getProfileSpecificResolvables(context, location, profiles));
    }

    private Set<Resolvable> getResolvables(ConfigDataLocationResolverContext context, String location) {
        String resourceLocation = this.getResourceLocation(context, location);
        try {
            if (this.isDirectoryLocation(resourceLocation)) {
                return this.getResolvablesForDirectory(resourceLocation, NO_PROFILE);
            }
            return this.getResolvablesForFile(resourceLocation, NO_PROFILE);
        }
        catch (RuntimeException ex) {
            throw new IllegalStateException("Unable to load config data from '" + location + "'", ex);
        }
    }

    private Set<Resolvable> getProfileSpecificResolvables(ConfigDataLocationResolverContext context, String location, Profiles profiles) {
        LinkedHashSet<Resolvable> resolvables = new LinkedHashSet<Resolvable>();
        String resourceLocation = this.getResourceLocation(context, location);
        for (String profile : profiles) {
            resolvables.addAll(this.getResolvables(resourceLocation, profile));
        }
        return resolvables;
    }

    private String getResourceLocation(ConfigDataLocationResolverContext context, String location) {
        boolean isAbsolute;
        String resourceLocation = location.startsWith(PREFIX) ? location.substring(PREFIX.length()) : location;
        boolean bl = isAbsolute = resourceLocation.startsWith("/") || URL_PREFIX.matcher(resourceLocation).matches();
        if (isAbsolute) {
            return resourceLocation;
        }
        ConfigDataLocation parent = context.getParent();
        if (parent instanceof ResourceConfigDataLocation) {
            String parentLocation = ((ResourceConfigDataLocation)parent).getLocation();
            String parentDirectory = parentLocation.substring(0, parentLocation.lastIndexOf("/") + 1);
            return parentDirectory + resourceLocation;
        }
        return resourceLocation;
    }

    private Set<Resolvable> getResolvables(String resourceLocation, String profile) {
        if (this.isDirectoryLocation(resourceLocation)) {
            return this.getResolvablesForDirectory(resourceLocation, profile);
        }
        return this.getResolvablesForFile(resourceLocation, profile);
    }

    private Set<Resolvable> getResolvablesForDirectory(String resourceLocation, String profile) {
        LinkedHashSet<Resolvable> resolvables = new LinkedHashSet<Resolvable>();
        for (String name : this.configNames) {
            for (PropertySourceLoader loader : this.propertySourceLoaders) {
                for (String extension : loader.getFileExtensions()) {
                    resolvables.add(new Resolvable(resourceLocation + name, profile, extension, loader));
                }
            }
        }
        return resolvables;
    }

    private Set<Resolvable> getResolvablesForFile(String resourceLocation, String profile) {
        for (PropertySourceLoader loader : this.propertySourceLoaders) {
            String extension = this.getLoadableFileExtension(loader, resourceLocation);
            if (extension == null) continue;
            String root = resourceLocation.substring(0, resourceLocation.length() - extension.length() - 1);
            return Collections.singleton(new Resolvable(root, profile, extension, loader));
        }
        throw new IllegalStateException("File extension is not known to any PropertySourceLoader. If the location is meant to reference a directory, it must end in '/'");
    }

    private String getLoadableFileExtension(PropertySourceLoader loader, String resourceLocation) {
        for (String fileExtension : loader.getFileExtensions()) {
            if (!StringUtils.endsWithIgnoreCase((String)resourceLocation, (String)fileExtension)) continue;
            return fileExtension;
        }
        return null;
    }

    private boolean isDirectoryLocation(String resourceLocation) {
        return resourceLocation.endsWith("/");
    }

    private List<ResourceConfigDataLocation> resolve(String location, Set<Resolvable> resolvables) {
        ArrayList<ResourceConfigDataLocation> resolved = new ArrayList<ResourceConfigDataLocation>();
        for (Resolvable resolvable : resolvables) {
            resolved.addAll(this.resolve(location, resolvable));
        }
        return resolved;
    }

    private List<ResourceConfigDataLocation> resolve(String location, Resolvable resolvable) {
        if (!resolvable.isPatternLocation()) {
            return this.resolveNonPattern(location, resolvable);
        }
        return this.resolvePattern(location, resolvable);
    }

    private List<ResourceConfigDataLocation> resolveNonPattern(String location, Resolvable resolvable) {
        Resource resource = this.loadResource(resolvable.getResourceLocation());
        if (resource.exists()) {
            ResourceConfigDataLocation resolved = this.createConfigResourceLocation(location, resolvable, resource);
            return Collections.singletonList(resolved);
        }
        this.logSkippingResource(resolvable);
        return Collections.emptyList();
    }

    private List<ResourceConfigDataLocation> resolvePattern(String location, Resolvable resolvable) {
        this.validatePatternLocation(resolvable.getResourceLocation());
        ArrayList<ResourceConfigDataLocation> resolved = new ArrayList<ResourceConfigDataLocation>();
        for (Resource resource : this.getResourcesFromResourceLocationPattern(resolvable.getResourceLocation())) {
            if (resource.exists()) {
                resolved.add(this.createConfigResourceLocation(location, resolvable, resource));
                continue;
            }
            this.logSkippingResource(resolvable);
        }
        return resolved;
    }

    private void logSkippingResource(Resolvable resolvable) {
        this.logger.trace((Object)LogMessage.format((String)"Skipping missing resource location %s", (Object)resolvable.getResourceLocation()));
    }

    private ResourceConfigDataLocation createConfigResourceLocation(String location, Resolvable resolvable, Resource resource) {
        String name = String.format("Resource config '%s' imported via location \"%s\"", resolvable.getResourceLocation(), location);
        return new ResourceConfigDataLocation(name, resource, resolvable.getLoader());
    }

    private void validatePatternLocation(String resourceLocation) {
        Assert.state((!resourceLocation.startsWith("classpath*:") ? 1 : 0) != 0, (String)"Classpath wildcard patterns cannot be used as a search location");
        Assert.state((StringUtils.countOccurrencesOf((String)resourceLocation, (String)"*") == 1 ? 1 : 0) != 0, () -> "Search location '" + resourceLocation + "' cannot contain multiple wildcards");
        String directoryPath = resourceLocation.substring(0, resourceLocation.lastIndexOf("/") + 1);
        Assert.state((boolean)directoryPath.endsWith("*/"), () -> "Search location '" + resourceLocation + "' must end with '*/'");
    }

    private Resource[] getResourcesFromResourceLocationPattern(String resourceLocationPattern) {
        String directoryPath = resourceLocationPattern.substring(0, resourceLocationPattern.indexOf("*/"));
        String fileName = resourceLocationPattern.substring(resourceLocationPattern.lastIndexOf("/") + 1);
        Resource directoryResource = this.loadResource(directoryPath);
        if (!directoryResource.exists()) {
            return EMPTY_RESOURCES;
        }
        File directory = this.getDirectory(resourceLocationPattern, directoryResource);
        File[] subDirectories = directory.listFiles(File::isDirectory);
        if (subDirectories == null) {
            return EMPTY_RESOURCES;
        }
        Arrays.sort(subDirectories, FILE_COMPARATOR);
        ArrayList resources = new ArrayList();
        FilenameFilter filter = (dir, name) -> name.equals(fileName);
        for (File subDirectory : subDirectories) {
            File[] files = subDirectory.listFiles(filter);
            if (files == null) continue;
            Arrays.stream(files).map(FileSystemResource::new).forEach(resources::add);
        }
        return resources.toArray(EMPTY_RESOURCES);
    }

    private Resource loadResource(String location) {
        if (!ResourceUtils.isUrl((String)(location = StringUtils.cleanPath((String)location)))) {
            location = "file:" + location;
        }
        return this.resourceLoader.getResource(location);
    }

    private File getDirectory(String patternLocation, Resource resource) {
        try {
            File directory = resource.getFile();
            Assert.state((boolean)directory.isDirectory(), () -> "'" + directory + "' is not a directory");
            return directory;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to load config data resource from pattern '" + patternLocation + "'", ex);
        }
    }

    private static class Resolvable {
        private final String resourceLocation;
        private final PropertySourceLoader loader;

        Resolvable(String rootLocation, String profile, String extension, PropertySourceLoader loader) {
            String profileSuffix = StringUtils.hasText((String)profile) ? "-" + profile : "";
            this.resourceLocation = rootLocation + profileSuffix + "." + extension;
            this.loader = loader;
        }

        boolean isPatternLocation() {
            return this.resourceLocation.contains("*");
        }

        String getResourceLocation() {
            return this.resourceLocation;
        }

        PropertySourceLoader getLoader() {
            return this.loader;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Resolvable other = (Resolvable)obj;
            return this.resourceLocation.equals(other.resourceLocation);
        }

        public int hashCode() {
            return this.resourceLocation.hashCode();
        }

        public String toString() {
            return this.resourceLocation;
        }
    }
}

