/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.io.IOException;
import java.util.List;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.FileUrlResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

class ResourceConfigDataLocation
extends ConfigDataLocation {
    private final String name;
    private final Resource resource;
    private final PropertySourceLoader propertySourceLoader;

    ResourceConfigDataLocation(String name, Resource resource, PropertySourceLoader propertySourceLoader) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        Assert.notNull((Object)propertySourceLoader, (String)"PropertySourceLoader must not be null");
        this.name = name;
        this.resource = resource;
        this.propertySourceLoader = propertySourceLoader;
    }

    String getLocation() {
        return this.name;
    }

    List<PropertySource<?>> load() throws IOException {
        return this.propertySourceLoader.load(this.name, this.resource);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceConfigDataLocation other = (ResourceConfigDataLocation)obj;
        return this.resource.equals(other.resource);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public String toString() {
        if (this.resource instanceof FileSystemResource || this.resource instanceof FileUrlResource) {
            try {
                return "file [" + this.resource.getFile().toString() + "]";
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.resource.toString();
    }
}

