/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import org.springframework.boot.context.config.ConfigDataEnvironmentContributor;
import org.springframework.boot.context.config.ConfigDataException;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.origin.Origin;
import org.springframework.core.env.PropertySource;

public class InactiveConfigDataAccessException
extends ConfigDataException {
    private final PropertySource<?> propertySource;
    private final ConfigDataLocation location;
    private final String propertyName;
    private final Origin origin;

    InactiveConfigDataAccessException(PropertySource<?> propertySource, ConfigDataLocation location, String propertyName, Origin origin) {
        super(InactiveConfigDataAccessException.getMessage(propertySource, location, propertyName, origin), null);
        this.propertySource = propertySource;
        this.location = location;
        this.propertyName = propertyName;
        this.origin = origin;
    }

    private static String getMessage(PropertySource<?> propertySource, ConfigDataLocation location, String propertyName, Origin origin) {
        StringBuilder message = new StringBuilder("Inactive property source '");
        message.append(propertySource.getName());
        if (location != null) {
            message.append("' imported from location '");
            message.append(location);
        }
        message.append("' cannot contain property '");
        message.append(propertyName);
        message.append("'");
        if (origin != null) {
            message.append(" [origin: ");
            message.append(origin);
            message.append("]");
        }
        return message.toString();
    }

    public PropertySource<?> getPropertySource() {
        return this.propertySource;
    }

    public ConfigDataLocation getLocation() {
        return this.location;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    static void throwIfPropertyFound(ConfigDataEnvironmentContributor contributor, ConfigurationPropertyName name) {
        ConfigurationProperty property;
        ConfigurationPropertySource source = contributor.getConfigurationPropertySource();
        ConfigurationProperty configurationProperty = property = source != null ? source.getConfigurationProperty(name) : null;
        if (property != null) {
            PropertySource<?> propertySource = contributor.getPropertySource();
            ConfigDataLocation location = contributor.getLocation();
            throw new InactiveConfigDataAccessException(propertySource, location, name.toString(), property.getOrigin());
        }
    }
}

