/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.util.Assert;

class ConfigTreeConfigDataLocation
extends ConfigDataLocation {
    private final Path path;

    ConfigTreeConfigDataLocation(String path) {
        Assert.notNull((Object)path, (String)"Path must not be null");
        this.path = Paths.get(path, new String[0]).toAbsolutePath();
    }

    Path getPath() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigTreeConfigDataLocation other = (ConfigTreeConfigDataLocation)obj;
        return Objects.equals(this.path, other.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return "config tree [" + this.path + "]";
    }
}

