/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.Instantiator;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;

class ConfigDataLoaders {
    private final Log logger;
    private final List<ConfigDataLoader<?>> loaders;
    private final List<Class<?>> locationTypes;

    ConfigDataLoaders(DeferredLogFactory logFactory) {
        this(logFactory, SpringFactoriesLoader.loadFactoryNames(ConfigDataLoader.class, null));
    }

    ConfigDataLoaders(DeferredLogFactory logFactory, List<String> names) {
        this.logger = logFactory.getLog(this.getClass());
        Instantiator instantiator = new Instantiator(ConfigDataLoader.class, availableParameters -> availableParameters.add(Log.class, logFactory::getLog));
        this.loaders = instantiator.instantiate(names);
        this.locationTypes = this.getLocationTypes(this.loaders);
    }

    private List<Class<?>> getLocationTypes(List<ConfigDataLoader<?>> loaders) {
        ArrayList locationTypes = new ArrayList(loaders.size());
        for (ConfigDataLoader<?> loader : loaders) {
            locationTypes.add(this.getLocationType(loader));
        }
        return Collections.unmodifiableList(locationTypes);
    }

    private Class<?> getLocationType(ConfigDataLoader<?> loader) {
        return ResolvableType.forClass(loader.getClass()).as(ConfigDataLoader.class).resolveGeneric(new int[0]);
    }

    <L extends ConfigDataLocation> ConfigData load(L location) throws IOException {
        ConfigDataLoader loader = this.getLoader(location);
        this.logger.trace((Object)LogMessage.of(() -> "Loading " + location + " using loader " + loader.getClass().getName()));
        return loader.load(location);
    }

    private <L extends ConfigDataLocation> ConfigDataLoader<L> getLoader(L location) {
        ConfigDataLoader<?> result = null;
        for (int i = 0; i < this.loaders.size(); ++i) {
            ConfigDataLoader<?> loader;
            ConfigDataLoader<?> candidate = this.loaders.get(i);
            if (!this.locationTypes.get(i).isInstance(location) || !(loader = candidate).isLoadable(location)) continue;
            if (result != null) {
                throw new IllegalStateException("Multiple loaders found for location " + location + " [" + candidate.getClass().getName() + "," + result.getClass().getName() + "]");
            }
            result = loader;
        }
        Assert.state((result != null ? 1 : 0) != 0, () -> "No loader found for location '" + location + "'");
        return result;
    }
}

