/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataActivationContext;
import org.springframework.boot.context.config.ConfigDataLoaders;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataLocationResolvers;
import org.springframework.boot.context.config.Profiles;

class ConfigDataImporter {
    private final ConfigDataLocationResolvers resolvers;
    private final ConfigDataLoaders loaders;
    private final Set<ConfigDataLocation> loadedLocations = new HashSet<ConfigDataLocation>();

    ConfigDataImporter(ConfigDataLocationResolvers resolvers, ConfigDataLoaders loaders) {
        this.resolvers = resolvers;
        this.loaders = loaders;
    }

    Map<ConfigDataLocation, ConfigData> resolveAndLoad(ConfigDataActivationContext activationContext, ConfigDataLocationResolverContext locationResolverContext, List<String> locations) {
        try {
            Profiles profiles = activationContext != null ? activationContext.getProfiles() : null;
            return this.load(this.resolvers.resolveAll(locationResolverContext, locations, profiles));
        }
        catch (IOException ex) {
            throw new IllegalStateException("IO error on loading imports from " + locations, ex);
        }
    }

    private Map<ConfigDataLocation, ConfigData> load(List<ConfigDataLocation> locations) throws IOException {
        LinkedHashMap<ConfigDataLocation, ConfigData> result = new LinkedHashMap<ConfigDataLocation, ConfigData>();
        for (int i = locations.size() - 1; i >= 0; --i) {
            ConfigDataLocation location = locations.get(i);
            if (!this.loadedLocations.add(location)) continue;
            result.put(location, this.loaders.load(location));
        }
        return Collections.unmodifiableMap(result);
    }
}

