/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.metrics.ApplicationStartup;
import org.springframework.core.metrics.StartupStep;
import org.springframework.util.ReflectionUtils;

class SpringApplicationRunListeners {
    private final Log log;
    private final List<SpringApplicationRunListener> listeners;
    private final ApplicationStartup applicationStartup;

    SpringApplicationRunListeners(Log log, Collection<? extends SpringApplicationRunListener> listeners, ApplicationStartup applicationStartup) {
        this.log = log;
        this.listeners = new ArrayList<SpringApplicationRunListener>(listeners);
        this.applicationStartup = applicationStartup;
    }

    void starting() {
        this.doWithListeners("spring.boot.application.starting", SpringApplicationRunListener::starting);
    }

    void environmentPrepared(ConfigurableEnvironment environment) {
        this.doWithListeners("spring.boot.application.environment-prepared", listener -> listener.environmentPrepared(environment));
    }

    void contextPrepared(ConfigurableApplicationContext context) {
        this.doWithListeners("spring.boot.application.context-prepared", listener -> listener.contextPrepared(context));
    }

    void contextLoaded(ConfigurableApplicationContext context) {
        this.doWithListeners("spring.boot.application.context-loaded", listener -> listener.contextLoaded(context));
    }

    void started(ConfigurableApplicationContext context) {
        this.doWithListeners("spring.boot.application.started", listener -> listener.started(context));
    }

    void running(ConfigurableApplicationContext context) {
        this.doWithListeners("spring.boot.application.running", listener -> listener.running(context));
    }

    void failed(ConfigurableApplicationContext context, Throwable exception) {
        this.doWithListeners("spring.boot.application.failed", listener -> this.callFailedListener((SpringApplicationRunListener)listener, context, exception), step -> {
            step.tag("exception", exception.getClass().toString());
            step.tag("message", exception.getMessage());
        });
    }

    private void callFailedListener(SpringApplicationRunListener listener, ConfigurableApplicationContext context, Throwable exception) {
        try {
            listener.failed(context, exception);
        }
        catch (Throwable ex) {
            if (exception == null) {
                ReflectionUtils.rethrowRuntimeException((Throwable)ex);
            }
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)"Error handling failed", ex);
            }
            String message = ex.getMessage();
            message = message != null ? message : "no error message";
            this.log.warn((Object)("Error handling failed (" + message + ")"));
        }
    }

    private void doWithListeners(String stepName, Consumer<SpringApplicationRunListener> listenerAction) {
        this.doWithListeners(stepName, listenerAction, null);
    }

    private void doWithListeners(String stepName, Consumer<SpringApplicationRunListener> listenerAction, Consumer<StartupStep> stepAction) {
        StartupStep step = this.applicationStartup.start(stepName);
        this.listeners.forEach(listenerAction);
        if (stepAction != null) {
            stepAction.accept(step);
        }
        step.end();
    }
}

