/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet.error;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Order(value=-2147483648)
public class DefaultErrorAttributes
implements ErrorAttributes,
HandlerExceptionResolver,
Ordered {
    private static final String ERROR_ATTRIBUTE = DefaultErrorAttributes.class.getName() + ".ERROR";
    private final boolean includeException;

    public DefaultErrorAttributes() {
        this(false);
    }

    public DefaultErrorAttributes(boolean includeException) {
        this.includeException = includeException;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        this.storeErrorAttributes(request, ex);
        return null;
    }

    private void storeErrorAttributes(HttpServletRequest request, Exception ex) {
        request.setAttribute(ERROR_ATTRIBUTE, (Object)ex);
    }

    @Override
    @Deprecated
    public Map<String, Object> getErrorAttributes(WebRequest webRequest, boolean includeStackTrace) {
        return this.getErrorAttributes(webRequest, includeStackTrace, false, false);
    }

    @Override
    public Map<String, Object> getErrorAttributes(WebRequest webRequest, boolean includeStackTrace, boolean includeMessage, boolean includeBindingErrors) {
        LinkedHashMap<String, Object> errorAttributes = new LinkedHashMap<String, Object>();
        errorAttributes.put("timestamp", new Date());
        this.addStatus(errorAttributes, (RequestAttributes)webRequest);
        this.addErrorDetails(errorAttributes, webRequest, includeStackTrace, includeMessage, includeBindingErrors);
        this.addPath(errorAttributes, (RequestAttributes)webRequest);
        return errorAttributes;
    }

    private void addStatus(Map<String, Object> errorAttributes, RequestAttributes requestAttributes) {
        Integer status = (Integer)this.getAttribute(requestAttributes, "javax.servlet.error.status_code");
        if (status == null) {
            errorAttributes.put("status", 999);
            errorAttributes.put("error", "None");
            return;
        }
        errorAttributes.put("status", status);
        try {
            errorAttributes.put("error", HttpStatus.valueOf((int)status).getReasonPhrase());
        }
        catch (Exception ex) {
            errorAttributes.put("error", "Http Status " + status);
        }
    }

    private void addErrorDetails(Map<String, Object> errorAttributes, WebRequest webRequest, boolean includeStackTrace, boolean includeMessage, boolean includeBindingErrors) {
        Throwable error = this.getError(webRequest);
        if (error != null) {
            while (error instanceof ServletException && error.getCause() != null) {
                error = error.getCause();
            }
            if (this.includeException) {
                errorAttributes.put("exception", error.getClass().getName());
            }
            if (includeStackTrace) {
                this.addStackTrace(errorAttributes, error);
            }
        }
        this.addErrorMessage(errorAttributes, webRequest, error, includeMessage, includeBindingErrors);
    }

    private void addErrorMessage(Map<String, Object> errorAttributes, WebRequest webRequest, Throwable error, boolean includeMessage, boolean includeBindingErrors) {
        BindingResult result = this.extractBindingResult(error);
        if (result == null) {
            this.addExceptionErrorMessage(errorAttributes, webRequest, error, includeMessage);
        } else {
            this.addBindingResultErrorMessage(errorAttributes, result, includeMessage, includeBindingErrors);
        }
    }

    private void addExceptionErrorMessage(Map<String, Object> errorAttributes, WebRequest webRequest, Throwable error, boolean includeMessage) {
        if (!includeMessage) {
            errorAttributes.put("message", "");
            return;
        }
        Object message = this.getAttribute((RequestAttributes)webRequest, "javax.servlet.error.message");
        if (StringUtils.isEmpty(message) && error != null) {
            message = error.getMessage();
        }
        if (StringUtils.isEmpty(message)) {
            message = "No message available";
        }
        errorAttributes.put("message", message);
    }

    private void addBindingResultErrorMessage(Map<String, Object> errorAttributes, BindingResult result, boolean includeMessage, boolean includeBindingErrors) {
        errorAttributes.put("message", includeMessage ? "Validation failed for object='" + result.getObjectName() + "'. Error count: " + result.getErrorCount() : "");
        if (includeBindingErrors && result.hasErrors()) {
            errorAttributes.put("errors", result.getAllErrors());
        }
    }

    private BindingResult extractBindingResult(Throwable error) {
        if (error instanceof BindingResult) {
            return (BindingResult)error;
        }
        if (error instanceof MethodArgumentNotValidException) {
            return ((MethodArgumentNotValidException)error).getBindingResult();
        }
        return null;
    }

    private void addStackTrace(Map<String, Object> errorAttributes, Throwable error) {
        StringWriter stackTrace = new StringWriter();
        error.printStackTrace(new PrintWriter(stackTrace));
        stackTrace.flush();
        errorAttributes.put("trace", stackTrace.toString());
    }

    private void addPath(Map<String, Object> errorAttributes, RequestAttributes requestAttributes) {
        String path = (String)this.getAttribute(requestAttributes, "javax.servlet.error.request_uri");
        if (path != null) {
            errorAttributes.put("path", path);
        }
    }

    @Override
    public Throwable getError(WebRequest webRequest) {
        Throwable exception = (Throwable)this.getAttribute((RequestAttributes)webRequest, ERROR_ATTRIBUTE);
        return exception != null ? exception : (Throwable)this.getAttribute((RequestAttributes)webRequest, "javax.servlet.error.exception");
    }

    private <T> T getAttribute(RequestAttributes requestAttributes, String name) {
        return (T)requestAttributes.getAttribute(name, 0);
    }
}

