/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.DefaultAccessLogReceiver;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.web.embedded.undertow.ConfigurableUndertowWebServerFactory;
import org.springframework.boot.web.embedded.undertow.SslBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowCompressionConfigurer;
import org.springframework.boot.web.embedded.undertow.UndertowGracefulShutdown;
import org.springframework.boot.web.embedded.undertow.UndertowWebServer;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.boot.web.server.GracefulShutdown;
import org.springframework.boot.web.server.WebServer;
import org.springframework.http.server.reactive.UndertowHttpHandlerAdapter;
import org.springframework.util.Assert;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class UndertowReactiveWebServerFactory
extends AbstractReactiveWebServerFactory
implements ConfigurableUndertowWebServerFactory {
    private Set<UndertowBuilderCustomizer> builderCustomizers = new LinkedHashSet<UndertowBuilderCustomizer>();
    private Integer bufferSize;
    private Integer ioThreads;
    private Integer workerThreads;
    private Boolean directBuffers;
    private File accessLogDirectory;
    private String accessLogPattern;
    private String accessLogPrefix;
    private String accessLogSuffix;
    private boolean accessLogEnabled = false;
    private boolean accessLogRotate = true;
    private boolean useForwardHeaders;

    public UndertowReactiveWebServerFactory() {
    }

    public UndertowReactiveWebServerFactory(int port) {
        super(port);
    }

    @Override
    public WebServer getWebServer(org.springframework.http.server.reactive.HttpHandler httpHandler) {
        Undertow.Builder builder = this.createBuilder(this.getPort());
        UndertowHttpHandlerAdapter handler = new UndertowHttpHandlerAdapter(httpHandler);
        if (this.useForwardHeaders) {
            handler = Handlers.proxyPeerAddress((HttpHandler)handler);
        }
        handler = UndertowCompressionConfigurer.configureCompression(this.getCompression(), (HttpHandler)handler);
        Closeable closeable = null;
        if (this.isAccessLogEnabled()) {
            AccessLogHandlerConfiguration accessLogHandlerConfiguration = this.configureAccessLogHandler((HttpHandler)handler);
            closeable = accessLogHandlerConfiguration.closeable;
            handler = accessLogHandlerConfiguration.accessLogHandler;
        }
        GracefulShutdown gracefulShutdown = null;
        GracefulShutdownHandler gracefulShutdownHandler = Handlers.gracefulShutdown((HttpHandler)handler);
        Duration gracePeriod = this.getShutdown().getGracePeriod();
        if (gracePeriod != null) {
            gracefulShutdown = new UndertowGracefulShutdown(gracefulShutdownHandler, gracePeriod);
            handler = gracefulShutdownHandler;
        } else {
            gracefulShutdown = GracefulShutdown.IMMEDIATE;
        }
        builder.setHandler((HttpHandler)handler);
        return new UndertowWebServer(builder, this.getPort() >= 0, closeable, gracefulShutdown);
    }

    private Undertow.Builder createBuilder(int port) {
        Undertow.Builder builder = Undertow.builder();
        if (this.bufferSize != null) {
            builder.setBufferSize(this.bufferSize.intValue());
        }
        if (this.ioThreads != null) {
            builder.setIoThreads(this.ioThreads.intValue());
        }
        if (this.workerThreads != null) {
            builder.setWorkerThreads(this.workerThreads.intValue());
        }
        if (this.directBuffers != null) {
            builder.setDirectBuffers(this.directBuffers.booleanValue());
        }
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            this.customizeSsl(builder);
        } else {
            builder.addHttpListener(port, this.getListenAddress());
        }
        for (UndertowBuilderCustomizer customizer : this.builderCustomizers) {
            customizer.customize(builder);
        }
        return builder;
    }

    private AccessLogHandlerConfiguration configureAccessLogHandler(HttpHandler handler) {
        try {
            this.createAccessLogDirectoryIfNecessary();
            XnioWorker worker = this.createWorker();
            String prefix = this.accessLogPrefix != null ? this.accessLogPrefix : "access_log.";
            DefaultAccessLogReceiver accessLogReceiver = new DefaultAccessLogReceiver((Executor)worker, this.accessLogDirectory, prefix, this.accessLogSuffix, this.accessLogRotate);
            String formatString = this.accessLogPattern != null ? this.accessLogPattern : "common";
            AccessLogHandler accessLogHandler = new AccessLogHandler(handler, (AccessLogReceiver)accessLogReceiver, formatString, Undertow.class.getClassLoader());
            return new AccessLogHandlerConfiguration(accessLogHandler, () -> {
                try {
                    accessLogReceiver.close();
                    worker.shutdown();
                    worker.awaitTermination(30L, TimeUnit.SECONDS);
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            });
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to create AccessLogHandler", ex);
        }
    }

    private void createAccessLogDirectoryIfNecessary() {
        Assert.state((this.accessLogDirectory != null ? 1 : 0) != 0, (String)"Access log directory is not set");
        if (!this.accessLogDirectory.isDirectory() && !this.accessLogDirectory.mkdirs()) {
            throw new IllegalStateException("Failed to create access log directory '" + this.accessLogDirectory + "'");
        }
    }

    private XnioWorker createWorker() throws IOException {
        Xnio xnio = Xnio.getInstance((ClassLoader)Undertow.class.getClassLoader());
        return xnio.createWorker(OptionMap.builder().set(Options.THREAD_DAEMON, true).getMap());
    }

    private void customizeSsl(Undertow.Builder builder) {
        new SslBuilderCustomizer(this.getPort(), this.getAddress(), this.getSsl(), this.getSslStoreProvider()).customize(builder);
        if (this.getHttp2() != null) {
            builder.setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)this.getHttp2().isEnabled());
        }
    }

    private String getListenAddress() {
        if (this.getAddress() == null) {
            return "0.0.0.0";
        }
        return this.getAddress().getHostAddress();
    }

    @Override
    public void setAccessLogDirectory(File accessLogDirectory) {
        this.accessLogDirectory = accessLogDirectory;
    }

    @Override
    public void setAccessLogPattern(String accessLogPattern) {
        this.accessLogPattern = accessLogPattern;
    }

    @Override
    public void setAccessLogPrefix(String accessLogPrefix) {
        this.accessLogPrefix = accessLogPrefix;
    }

    @Override
    public void setAccessLogSuffix(String accessLogSuffix) {
        this.accessLogSuffix = accessLogSuffix;
    }

    public boolean isAccessLogEnabled() {
        return this.accessLogEnabled;
    }

    @Override
    public void setAccessLogEnabled(boolean accessLogEnabled) {
        this.accessLogEnabled = accessLogEnabled;
    }

    @Override
    public void setAccessLogRotate(boolean accessLogRotate) {
        this.accessLogRotate = accessLogRotate;
    }

    protected final boolean isUseForwardHeaders() {
        return this.useForwardHeaders;
    }

    @Override
    public void setUseForwardHeaders(boolean useForwardHeaders) {
        this.useForwardHeaders = useForwardHeaders;
    }

    @Override
    public void setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public void setIoThreads(Integer ioThreads) {
        this.ioThreads = ioThreads;
    }

    @Override
    public void setWorkerThreads(Integer workerThreads) {
        this.workerThreads = workerThreads;
    }

    @Override
    public void setUseDirectBuffers(Boolean directBuffers) {
        this.directBuffers = directBuffers;
    }

    public void setBuilderCustomizers(Collection<? extends UndertowBuilderCustomizer> customizers) {
        Assert.notNull(customizers, (String)"Customizers must not be null");
        this.builderCustomizers = new LinkedHashSet<UndertowBuilderCustomizer>(customizers);
    }

    public Collection<UndertowBuilderCustomizer> getBuilderCustomizers() {
        return this.builderCustomizers;
    }

    @Override
    public void addBuilderCustomizers(UndertowBuilderCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"Customizers must not be null");
        this.builderCustomizers.addAll(Arrays.asList(customizers));
    }

    private static final class AccessLogHandlerConfiguration {
        private final AccessLogHandler accessLogHandler;
        private final Closeable closeable;

        private AccessLogHandlerConfiguration(AccessLogHandler accessLogHandler, Closeable closeable) {
            this.accessLogHandler = accessLogHandler;
            this.closeable = closeable;
        }
    }
}

