/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.jetty;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.springframework.boot.web.server.GracefulShutdown;

class JettyGracefulShutdown
implements GracefulShutdown {
    private static final Log logger = LogFactory.getLog(JettyGracefulShutdown.class);
    private final Server server;
    private final Supplier<Integer> activeRequests;
    private final Duration period;
    private volatile boolean shuttingDown = false;

    JettyGracefulShutdown(Server server, Supplier<Integer> activeRequests, Duration period) {
        this.server = server;
        this.activeRequests = activeRequests;
        this.period = period;
    }

    @Override
    public boolean shutDownGracefully() {
        logger.info((Object)("Commencing graceful shutdown, allowing up to " + this.period.getSeconds() + "s for active requests to complete"));
        for (Connector connector : this.server.getConnectors()) {
            this.shutdown(connector);
        }
        this.shuttingDown = true;
        long end = System.currentTimeMillis() + this.period.toMillis();
        while (System.currentTimeMillis() < end && this.activeRequests.get() > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.shuttingDown = false;
        long activeRequests = this.activeRequests.get().intValue();
        if (activeRequests == 0L) {
            logger.info((Object)"Graceful shutdown complete");
            return true;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Grace period elapsed with " + activeRequests + " request(s) still active"));
        }
        return activeRequests == 0L;
    }

    private void shutdown(Connector connector) {
        try {
            connector.shutdown().get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Override
    public boolean isShuttingDown() {
        return this.shuttingDown;
    }
}

