/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.availability;

import org.springframework.boot.availability.AvailabilityState;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.Assert;

public class AvailabilityChangeEvent<S extends AvailabilityState>
extends ApplicationEvent {
    private final S state;

    public AvailabilityChangeEvent(Object source, S state) {
        super(source);
        Assert.notNull(state, (String)"State must not be null");
        this.state = state;
    }

    public S getState() {
        return this.state;
    }

    public static <S extends AvailabilityState> void publish(ApplicationContext context, S state) {
        Assert.notNull((Object)context, (String)"Context must not be null");
        AvailabilityChangeEvent.publish((ApplicationEventPublisher)context, context, state);
    }

    public static <S extends AvailabilityState> void publish(ApplicationEventPublisher publisher, Object source, S state) {
        Assert.notNull((Object)publisher, (String)"Publisher must not be null");
        publisher.publishEvent(new AvailabilityChangeEvent<S>(source, state));
    }
}

