/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.undertow;

import io.undertow.server.handlers.GracefulShutdownHandler;
import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.server.GracefulShutdown;

class UndertowGracefulShutdown
implements GracefulShutdown {
    private static final Log logger = LogFactory.getLog(UndertowGracefulShutdown.class);
    private final GracefulShutdownHandler gracefulShutdownHandler;
    private final Duration period;
    private volatile boolean shuttingDown;

    UndertowGracefulShutdown(GracefulShutdownHandler gracefulShutdownHandler, Duration period) {
        this.gracefulShutdownHandler = gracefulShutdownHandler;
        this.period = period;
    }

    @Override
    public boolean shutDownGracefully() {
        logger.info((Object)("Commencing graceful shutdown, allowing up to " + this.period.getSeconds() + "s for active requests to complete"));
        this.gracefulShutdownHandler.shutdown();
        this.shuttingDown = true;
        boolean graceful = false;
        try {
            graceful = this.gracefulShutdownHandler.awaitShutdown(this.period.toMillis());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.shuttingDown = false;
        }
        if (graceful) {
            logger.info((Object)"Graceful shutdown complete");
            return true;
        }
        logger.info((Object)"Grace period elapsed with one or more requests still active");
        return graceful;
    }

    @Override
    public boolean isShuttingDown() {
        return this.shuttingDown;
    }
}

