/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.tomcat;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.catalina.Container;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.server.GracefulShutdown;

class TomcatGracefulShutdown
implements GracefulShutdown {
    private static final Log logger = LogFactory.getLog(TomcatGracefulShutdown.class);
    private final Tomcat tomcat;
    private final Duration period;
    private volatile boolean shuttingDown = false;

    TomcatGracefulShutdown(Tomcat tomcat, Duration period) {
        this.tomcat = tomcat;
        this.period = period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutDownGracefully() {
        logger.info((Object)("Commencing graceful shutdown, allowing up to " + this.period.getSeconds() + "s for active requests to complete"));
        List<Connector> connectors = this.getConnectors();
        for (Connector connector : connectors) {
            connector.pause();
            connector.getProtocolHandler().closeServerSocketGraceful();
        }
        this.shuttingDown = true;
        try {
            long end = System.currentTimeMillis() + this.period.toMillis();
            for (Container host : this.tomcat.getEngine().findChildren()) {
                for (Container context : host.findChildren()) {
                    while (this.active(context)) {
                        if (System.currentTimeMillis() > end) {
                            logger.info((Object)"Grace period elapsed with one or more requests still active");
                            boolean bl = false;
                            return bl;
                        }
                        Thread.sleep(50L);
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.shuttingDown = false;
        }
        logger.info((Object)"Graceful shutdown complete");
        return true;
    }

    private boolean active(Container context) {
        try {
            if (((StandardContext)context).getInProgressAsyncCount() > 0L) {
                return true;
            }
            for (Container wrapper : context.findChildren()) {
                if (((StandardWrapper)wrapper).getCountAllocated() <= 0) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private List<Connector> getConnectors() {
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        for (Service service : this.tomcat.getServer().findServices()) {
            for (Connector connector : service.findConnectors()) {
                connectors.add(connector);
            }
        }
        return connectors;
    }

    @Override
    public boolean isShuttingDown() {
        return this.shuttingDown;
    }
}

