/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.netty;

import java.time.Duration;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.server.GracefulShutdown;
import reactor.netty.DisposableServer;

final class NettyGracefulShutdown
implements GracefulShutdown {
    private static final Log logger = LogFactory.getLog(NettyGracefulShutdown.class);
    private final Supplier<DisposableServer> disposableServer;
    private final Duration period;
    private volatile boolean shuttingDown;

    NettyGracefulShutdown(Supplier<DisposableServer> disposableServer, Duration period) {
        this.disposableServer = disposableServer;
        this.period = period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutDownGracefully() {
        logger.info((Object)("Commencing graceful shutdown, allowing up to " + this.period.getSeconds() + "s for active requests to complete"));
        DisposableServer server = this.disposableServer.get();
        if (server == null) {
            return false;
        }
        this.shuttingDown = true;
        try {
            this.disposeNow(server);
            logger.info((Object)"Graceful shutdown complete");
            boolean bl = true;
            return bl;
        }
        catch (IllegalStateException ex) {
            logger.info((Object)"Grace period elapsed with one ore more requests still active");
            boolean bl = false;
            return bl;
        }
        finally {
            this.shuttingDown = false;
        }
    }

    private void disposeNow(DisposableServer server) {
        if (this.period != null) {
            server.disposeNow(this.period);
        } else {
            server.disposeNow();
        }
    }

    @Override
    public boolean isShuttingDown() {
        return this.shuttingDown;
    }
}

