/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.availability;

import org.springframework.boot.availability.LivenessState;
import org.springframework.boot.availability.LivenessStateChangedEvent;
import org.springframework.boot.availability.ReadinessState;
import org.springframework.boot.availability.ReadinessStateChangedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.Assert;

public class ApplicationAvailabilityProvider
implements ApplicationListener<ApplicationEvent> {
    private LivenessState livenessState;
    private ReadinessState readinessState;

    public ApplicationAvailabilityProvider() {
        this(LivenessState.BROKEN, ReadinessState.UNREADY);
    }

    public ApplicationAvailabilityProvider(LivenessState livenessState, ReadinessState readinessState) {
        Assert.notNull((Object)((Object)livenessState), (String)"LivenessState must not be null");
        Assert.notNull((Object)((Object)readinessState), (String)"ReadinessState must not be null");
        this.livenessState = livenessState;
        this.readinessState = readinessState;
    }

    public LivenessState getLivenessState() {
        return this.livenessState;
    }

    public ReadinessState getReadinessState() {
        return this.readinessState;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof LivenessStateChangedEvent) {
            LivenessStateChangedEvent livenessEvent = (LivenessStateChangedEvent)event;
            this.livenessState = livenessEvent.getLivenessState();
        } else if (event instanceof ReadinessStateChangedEvent) {
            ReadinessStateChangedEvent readinessEvent = (ReadinessStateChangedEvent)event;
            this.readinessState = readinessEvent.getReadinessState();
        }
    }
}

