/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;

public final class ConfigurationPropertiesBean {
    private final String name;
    private final Object instance;
    private final ConfigurationProperties annotation;
    private final Bindable<?> bindTarget;
    private final BindMethod bindMethod;

    private ConfigurationPropertiesBean(String name, Object instance, ConfigurationProperties annotation, Bindable<?> bindTarget, BindMethod bindMethod) {
        this.name = name;
        this.instance = instance;
        this.annotation = annotation;
        this.bindTarget = bindTarget;
        this.bindMethod = bindMethod;
    }

    public String getName() {
        return this.name;
    }

    public Object getInstance() {
        return this.instance;
    }

    Class<?> getType() {
        return this.bindTarget.getType().resolve();
    }

    public BindMethod getBindMethod() {
        return this.bindMethod;
    }

    public ConfigurationProperties getAnnotation() {
        return this.annotation;
    }

    public Bindable<?> asBindTarget() {
        return this.bindTarget;
    }

    public static Map<String, ConfigurationPropertiesBean> getAll(ApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext must not be null");
        if (applicationContext instanceof ConfigurableApplicationContext) {
            return ConfigurationPropertiesBean.getAll((ConfigurableApplicationContext)applicationContext);
        }
        LinkedHashMap<String, ConfigurationPropertiesBean> propertiesBeans = new LinkedHashMap<String, ConfigurationPropertiesBean>();
        applicationContext.getBeansWithAnnotation(ConfigurationProperties.class).forEach((beanName, bean) -> propertiesBeans.put((String)beanName, ConfigurationPropertiesBean.get(applicationContext, bean, beanName)));
        return propertiesBeans;
    }

    private static Map<String, ConfigurationPropertiesBean> getAll(ConfigurableApplicationContext applicationContext) {
        LinkedHashMap<String, ConfigurationPropertiesBean> propertiesBeans = new LinkedHashMap<String, ConfigurationPropertiesBean>();
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        Iterator beanNames = beanFactory.getBeanNamesIterator();
        while (beanNames.hasNext()) {
            String beanName = (String)beanNames.next();
            try {
                Object bean = beanFactory.getBean(beanName);
                ConfigurationPropertiesBean propertiesBean = ConfigurationPropertiesBean.get((ApplicationContext)applicationContext, bean, beanName);
                if (propertiesBean == null) continue;
                propertiesBeans.put(beanName, propertiesBean);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        }
        return propertiesBeans;
    }

    public static ConfigurationPropertiesBean get(ApplicationContext applicationContext, Object bean, String beanName) {
        Method factoryMethod = ConfigurationPropertiesBean.findFactoryMethod(applicationContext, beanName);
        return ConfigurationPropertiesBean.create(beanName, bean, bean.getClass(), factoryMethod);
    }

    private static Method findFactoryMethod(ApplicationContext applicationContext, String beanName) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            return ConfigurationPropertiesBean.findFactoryMethod((ConfigurableApplicationContext)applicationContext, beanName);
        }
        return null;
    }

    private static Method findFactoryMethod(ConfigurableApplicationContext applicationContext, String beanName) {
        BeanDefinition beanDefinition;
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        if (beanFactory.containsBeanDefinition(beanName) && (beanDefinition = beanFactory.getMergedBeanDefinition(beanName)) instanceof RootBeanDefinition) {
            return ((RootBeanDefinition)beanDefinition).getResolvedFactoryMethod();
        }
        return null;
    }

    static ConfigurationPropertiesBean forValueObject(Class<?> beanClass, String beanName) {
        ConfigurationPropertiesBean propertiesBean = ConfigurationPropertiesBean.create(beanName, null, beanClass, null);
        Assert.state((propertiesBean != null && propertiesBean.getBindMethod() == BindMethod.VALUE_OBJECT ? 1 : 0) != 0, (String)("Bean '" + beanName + "' is not a @ConfigurationProperties value object"));
        return propertiesBean;
    }

    private static ConfigurationPropertiesBean create(String name, Object instance, Class<?> type, Method factory) {
        Annotation[] annotationArray;
        ConfigurationProperties annotation = ConfigurationPropertiesBean.findAnnotation(instance, type, factory, ConfigurationProperties.class);
        if (annotation == null) {
            return null;
        }
        Validated validated = ConfigurationPropertiesBean.findAnnotation(instance, type, factory, Validated.class);
        if (validated != null) {
            Annotation[] annotationArray2 = new Annotation[2];
            annotationArray2[0] = annotation;
            annotationArray = annotationArray2;
            annotationArray2[1] = validated;
        } else {
            Annotation[] annotationArray3 = new Annotation[1];
            annotationArray = annotationArray3;
            annotationArray3[0] = annotation;
        }
        Annotation[] annotations = annotationArray;
        Constructor<?> bindConstructor = BindMethod.findBindConstructor(type);
        BindMethod bindMethod = bindConstructor != null ? BindMethod.VALUE_OBJECT : BindMethod.forClass(type);
        ResolvableType bindType = factory != null ? ResolvableType.forMethodReturnType((Method)factory) : ResolvableType.forClass(type);
        Bindable<Object> bindTarget = Bindable.of(bindType).withAnnotations(annotations).withConstructorFilter(ConfigurationPropertiesBean::isBindableConstructor);
        if (instance != null) {
            bindTarget = bindTarget.withExistingValue(instance);
        }
        return new ConfigurationPropertiesBean(name, instance, annotation, bindTarget, bindMethod);
    }

    private static <A extends Annotation> A findAnnotation(Object instance, Class<?> type, Method factory, Class<A> annotationType) {
        MergedAnnotation annotation = MergedAnnotation.missing();
        if (factory != null) {
            annotation = MergedAnnotations.from((AnnotatedElement)factory, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(annotationType);
        }
        if (!annotation.isPresent()) {
            annotation = MergedAnnotations.from(type, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(annotationType);
        }
        if (!annotation.isPresent() && AopUtils.isAopProxy((Object)instance)) {
            annotation = MergedAnnotations.from((AnnotatedElement)AopUtils.getTargetClass((Object)instance), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(annotationType);
        }
        return (A)(annotation.isPresent() ? annotation.synthesize() : null);
    }

    private static boolean isBindableConstructor(Constructor<?> constructor) {
        Class<?> declaringClass = constructor.getDeclaringClass();
        Constructor<?> bindConstructor = BindMethod.findBindConstructor(declaringClass);
        if (bindConstructor != null) {
            return bindConstructor.equals(constructor);
        }
        return BindMethod.forClass(declaringClass) == BindMethod.VALUE_OBJECT;
    }

    public static enum BindMethod {
        JAVA_BEAN,
        VALUE_OBJECT;


        static BindMethod forClass(Class<?> type) {
            if (BindMethod.isConstructorBindingType(type) || BindMethod.findBindConstructor(type) != null) {
                return VALUE_OBJECT;
            }
            return JAVA_BEAN;
        }

        private static boolean isConstructorBindingType(Class<?> type) {
            return MergedAnnotations.from(type, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY_AND_ENCLOSING_CLASSES).isPresent(ConstructorBinding.class);
        }

        static Constructor<?> findBindConstructor(Class<?> type) {
            Constructor constructor;
            if (KotlinDetector.isKotlinPresent() && KotlinDetector.isKotlinType(type) && (constructor = BeanUtils.findPrimaryConstructor(type)) != null) {
                return BindMethod.findBindConstructor(type, constructor);
            }
            return BindMethod.findBindConstructor(type, type.getDeclaredConstructors());
        }

        private static Constructor<?> findBindConstructor(Class<?> type, Constructor<?> ... candidates) {
            Constructor<?> constructor = null;
            for (Constructor<?> candidate : candidates) {
                if (!MergedAnnotations.from(candidate).isPresent(ConstructorBinding.class)) continue;
                Assert.state((candidate.getParameterCount() > 0 ? 1 : 0) != 0, (String)(type.getName() + " declares @ConstructorBinding on a no-args constructor"));
                Assert.state((constructor == null ? 1 : 0) != 0, (String)(type.getName() + " has more than one @ConstructorBinding constructor"));
                constructor = candidate;
            }
            return constructor;
        }
    }
}

