/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindException;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinder;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.validation.annotation.Validated;

final class ConfigurationPropertiesBeanDefinition
extends GenericBeanDefinition {
    ConfigurationPropertiesBeanDefinition() {
    }

    static ConfigurationPropertiesBeanDefinition from(ConfigurableListableBeanFactory beanFactory, String beanName, Class<?> type) {
        ConfigurationPropertiesBeanDefinition beanDefinition = new ConfigurationPropertiesBeanDefinition();
        beanDefinition.setBeanClass(type);
        beanDefinition.setInstanceSupplier(ConfigurationPropertiesBeanDefinition.createBean(beanFactory, beanName, type));
        return beanDefinition;
    }

    private static <T> Supplier<T> createBean(ConfigurableListableBeanFactory beanFactory, String beanName, Class<T> type) {
        return () -> {
            Annotation[] annotationArray;
            ConfigurationProperties annotation = ConfigurationPropertiesBeanDefinition.getAnnotation(type, ConfigurationProperties.class);
            Validated validated = ConfigurationPropertiesBeanDefinition.getAnnotation(type, Validated.class);
            if (validated != null) {
                Annotation[] annotationArray2 = new Annotation[2];
                annotationArray2[0] = annotation;
                annotationArray = annotationArray2;
                annotationArray2[1] = validated;
            } else {
                Annotation[] annotationArray3 = new Annotation[1];
                annotationArray = annotationArray3;
                annotationArray3[0] = annotation;
            }
            Annotation[] annotations = annotationArray;
            Bindable bindable = Bindable.of(type).withAnnotations(annotations);
            ConfigurationPropertiesBinder binder = (ConfigurationPropertiesBinder)beanFactory.getBean("org.springframework.boot.context.internalConfigurationPropertiesBinder", ConfigurationPropertiesBinder.class);
            try {
                return binder.bind(bindable).orElseCreate(type);
            }
            catch (Exception ex) {
                throw new ConfigurationPropertiesBindException(beanName, type, annotation, ex);
            }
        };
    }

    private static <A extends Annotation> A getAnnotation(Class<?> type, Class<A> annotationType) {
        return (A)AnnotationUtils.findAnnotation(type, annotationType);
    }
}

