/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.boot.origin.OriginTrackedValue;

abstract class SpringProfilesDocumentMatcher
implements YamlProcessor.DocumentMatcher {
    SpringProfilesDocumentMatcher() {
    }

    public final YamlProcessor.MatchStatus matches(Properties properties) {
        Binder binder = new Binder(new ConfigurationPropertySource[]{new OriginTrackedValueConfigurationPropertySource(properties)});
        String[] profiles = binder.bind("spring.profiles", Bindable.of(String[].class)).orElse(null);
        return this.matches(profiles) ? YamlProcessor.MatchStatus.ABSTAIN : YamlProcessor.MatchStatus.NOT_FOUND;
    }

    protected abstract boolean matches(String[] var1);

    static class OriginTrackedValueConfigurationPropertySource
    extends MapConfigurationPropertySource {
        OriginTrackedValueConfigurationPropertySource(Map<?, ?> map) {
            super(map);
        }

        @Override
        public ConfigurationProperty getConfigurationProperty(ConfigurationPropertyName name) {
            ConfigurationProperty property = super.getConfigurationProperty(name);
            if (property != null && property.getValue() instanceof OriginTrackedValue) {
                OriginTrackedValue originTrackedValue = (OriginTrackedValue)property.getValue();
                property = new ConfigurationProperty(property.getName(), originTrackedValue.getValue(), originTrackedValue.getOrigin());
            }
            return property;
        }
    }
}

