/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.beans.PropertyEditor;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.Assert;

class BindConverter {
    private final ConversionService conversionService;
    private final SimpleTypeConverter simpleTypeConverter;

    BindConverter(ConversionService conversionService, Consumer<PropertyEditorRegistry> propertyEditorInitializer) {
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        this.conversionService = conversionService;
        this.simpleTypeConverter = new SimpleTypeConverter();
        if (propertyEditorInitializer != null) {
            propertyEditorInitializer.accept((PropertyEditorRegistry)this.simpleTypeConverter);
        }
    }

    public boolean canConvert(Object value, ResolvableType type, Annotation ... annotations) {
        return this.getPropertyEditor(type.resolve()) != null || this.conversionService.canConvert(TypeDescriptor.forObject((Object)value), (TypeDescriptor)new ResolvableTypeDescriptor(type, annotations));
    }

    public <T> T convert(Object result, Bindable<T> target) {
        return this.convert(result, target.getType(), target.getAnnotations());
    }

    public <T> T convert(Object value, ResolvableType type, Annotation ... annotations) {
        PropertyEditor propertyEditor = this.getPropertyEditor(type.resolve());
        if (propertyEditor != null) {
            if (value == null) {
                return null;
            }
            return (T)this.simpleTypeConverter.convertIfNecessary(value, type.resolve());
        }
        return (T)this.conversionService.convert(value, TypeDescriptor.forObject((Object)value), (TypeDescriptor)new ResolvableTypeDescriptor(type, annotations));
    }

    private PropertyEditor getPropertyEditor(Class<?> type) {
        if (type == null || type == Object.class || Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type)) {
            return null;
        }
        PropertyEditor editor = this.simpleTypeConverter.getDefaultEditor(type);
        if (editor == null) {
            editor = this.simpleTypeConverter.findCustomEditor(type, null);
        }
        if (editor == null && String.class != type) {
            editor = BeanUtils.findEditorByConvention(type);
        }
        return editor;
    }

    final class ResolvableTypeDescriptor
    extends TypeDescriptor {
        ResolvableTypeDescriptor(ResolvableType resolvableType, Annotation[] annotations) {
            super(resolvableType, null, annotations);
        }
    }
}

