/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.env.RandomValuePropertySource;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class ConfigFileApplicationListener
implements EnvironmentPostProcessor,
SmartApplicationListener,
Ordered {
    private static final String DEFAULT_PROPERTIES = "defaultProperties";
    private static final String DEFAULT_SEARCH_LOCATIONS = "classpath:/,classpath:/config/,file:./,file:./config/";
    private static final String DEFAULT_NAMES = "application";
    public static final String ACTIVE_PROFILES_PROPERTY = "spring.profiles.active";
    public static final String INCLUDE_PROFILES_PROPERTY = "spring.profiles.include";
    public static final String CONFIG_NAME_PROPERTY = "spring.config.name";
    public static final String CONFIG_LOCATION_PROPERTY = "spring.config.location";
    public static final String CONFIG_ADDITIONAL_LOCATION_PROPERTY = "spring.config.additional-location";
    public static final int DEFAULT_ORDER = -2147483638;
    public static final String APPLICATION_CONFIGURATION_PROPERTY_SOURCE_NAME = "applicationConfigurationProperties";
    private final DeferredLog logger = new DeferredLog();
    private String searchLocations;
    private String names;
    private int order = -2147483638;

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ApplicationEnvironmentPreparedEvent.class.isAssignableFrom(eventType) || ApplicationPreparedEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> aClass) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            this.onApplicationEnvironmentPreparedEvent((ApplicationEnvironmentPreparedEvent)event);
        }
        if (event instanceof ApplicationPreparedEvent) {
            this.onApplicationPreparedEvent(event);
        }
    }

    private void onApplicationEnvironmentPreparedEvent(ApplicationEnvironmentPreparedEvent event) {
        List<EnvironmentPostProcessor> postProcessors = this.loadPostProcessors();
        postProcessors.add(this);
        AnnotationAwareOrderComparator.sort(postProcessors);
        for (EnvironmentPostProcessor postProcessor : postProcessors) {
            postProcessor.postProcessEnvironment(event.getEnvironment(), event.getSpringApplication());
        }
    }

    List<EnvironmentPostProcessor> loadPostProcessors() {
        return SpringFactoriesLoader.loadFactories(EnvironmentPostProcessor.class, (ClassLoader)this.getClass().getClassLoader());
    }

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.addPropertySources(environment, application.getResourceLoader());
    }

    private void onApplicationPreparedEvent(ApplicationEvent event) {
        this.logger.replayTo(ConfigFileApplicationListener.class);
        this.addPostProcessors(((ApplicationPreparedEvent)event).getApplicationContext());
    }

    protected void addPropertySources(ConfigurableEnvironment environment, ResourceLoader resourceLoader) {
        RandomValuePropertySource.addToEnvironment(environment);
        new Loader(environment, resourceLoader).load();
    }

    protected void addPostProcessors(ConfigurableApplicationContext context) {
        context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new PropertySourceOrderingPostProcessor(context));
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setSearchLocations(String locations) {
        Assert.hasLength((String)locations, (String)"Locations must not be empty");
        this.searchLocations = locations;
    }

    public void setSearchNames(String names) {
        Assert.hasLength((String)names, (String)"Names must not be empty");
        this.names = names;
    }

    private static class Profile {
        private final String name;
        private final boolean defaultProfile;

        Profile(String name) {
            this(name, false);
        }

        Profile(String name, boolean defaultProfile) {
            Assert.notNull((Object)name, (String)"Name must not be null");
            this.name = name;
            this.defaultProfile = defaultProfile;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDefaultProfile() {
            return this.defaultProfile;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return ((Profile)obj).name.equals(this.name);
        }
    }

    private class Loader {
        private final Log logger;
        private final ConfigurableEnvironment environment;
        private final ResourceLoader resourceLoader;
        private final List<PropertySourceLoader> propertySourceLoaders;
        private Queue<Profile> profiles;
        private List<Profile> processedProfiles;
        private boolean activatedProfiles;
        private Map<Profile, MutablePropertySources> loaded;

        Loader(ConfigurableEnvironment environment, ResourceLoader resourceLoader) {
            this.logger = ConfigFileApplicationListener.this.logger;
            this.environment = environment;
            this.resourceLoader = resourceLoader == null ? new DefaultResourceLoader() : resourceLoader;
            this.propertySourceLoaders = SpringFactoriesLoader.loadFactories(PropertySourceLoader.class, (ClassLoader)this.getClass().getClassLoader());
        }

        public void load() {
            this.profiles = Collections.asLifoQueue(new LinkedList());
            this.processedProfiles = new LinkedList<Profile>();
            this.activatedProfiles = false;
            this.loaded = new LinkedHashMap<Profile, MutablePropertySources>();
            this.initializeProfiles();
            while (!this.profiles.isEmpty()) {
                Profile profile = this.profiles.poll();
                for (String location : this.getSearchLocations()) {
                    if (!location.endsWith("/")) {
                        this.load(profile, location, null);
                        continue;
                    }
                    for (String name : this.getSearchNames()) {
                        this.load(profile, location, name);
                    }
                }
                this.processedProfiles.add(profile);
            }
            this.addLoadedPropertySources();
        }

        private void initializeProfiles() {
            Set<Profile> initialActiveProfiles = this.initializeActiveProfiles();
            this.profiles.addAll(this.getUnprocessedActiveProfiles(initialActiveProfiles));
            if (this.profiles.isEmpty()) {
                for (String defaultProfileName : this.environment.getDefaultProfiles()) {
                    Profile defaultProfile = new Profile(defaultProfileName, true);
                    if (this.profiles.contains(defaultProfile)) continue;
                    this.profiles.add(defaultProfile);
                }
            }
            this.profiles.add(null);
        }

        private Set<Profile> initializeActiveProfiles() {
            if (!this.environment.containsProperty(ConfigFileApplicationListener.ACTIVE_PROFILES_PROPERTY) && !this.environment.containsProperty(ConfigFileApplicationListener.INCLUDE_PROFILES_PROPERTY)) {
                return Collections.emptySet();
            }
            Binder binder = Binder.get((Environment)this.environment);
            LinkedHashSet<Profile> activeProfiles = new LinkedHashSet<Profile>();
            activeProfiles.addAll(this.getProfiles(binder, ConfigFileApplicationListener.ACTIVE_PROFILES_PROPERTY));
            activeProfiles.addAll(this.getProfiles(binder, ConfigFileApplicationListener.INCLUDE_PROFILES_PROPERTY));
            this.maybeActivateProfiles(activeProfiles);
            return activeProfiles;
        }

        private List<Profile> getUnprocessedActiveProfiles(Set<Profile> initialActiveProfiles) {
            ArrayList<Profile> unprocessedActiveProfiles = new ArrayList<Profile>();
            for (String profileName : this.environment.getActiveProfiles()) {
                Profile profile = new Profile(profileName);
                if (initialActiveProfiles.contains(profile)) continue;
                unprocessedActiveProfiles.add(profile);
            }
            Collections.reverse(unprocessedActiveProfiles);
            return unprocessedActiveProfiles;
        }

        private void load(Profile profile, String location, String name) {
            if (!StringUtils.hasText((String)name)) {
                for (PropertySourceLoader loader : this.propertySourceLoaders) {
                    if (!this.canLoadFileExtension(loader, location)) continue;
                    this.load(loader, profile, location, profile == null ? null : profile.getName());
                }
            }
            for (PropertySourceLoader loader : this.propertySourceLoaders) {
                for (String ext : loader.getFileExtensions()) {
                    this.loadForFileExtension(loader, profile, location + name, "." + ext);
                }
            }
        }

        private boolean canLoadFileExtension(PropertySourceLoader loader, String name) {
            return Arrays.stream(loader.getFileExtensions()).anyMatch(fileExtension -> StringUtils.endsWithIgnoreCase((String)name, (String)fileExtension));
        }

        private void loadForFileExtension(PropertySourceLoader loader, Profile profile, String prefix, String ext) {
            if (profile != null) {
                this.load(loader, profile, prefix + "-" + profile + ext, null);
                this.load(loader, profile, prefix + "-" + profile + ext, profile.getName());
                for (Profile processedProfile : this.processedProfiles) {
                    if (processedProfile == null) continue;
                    String previouslyLoaded = prefix + "-" + processedProfile + ext;
                    this.load(loader, profile, previouslyLoaded, profile.getName());
                }
            }
            this.load(loader, profile, prefix + ext, profile == null ? null : profile.getName());
        }

        private void load(PropertySourceLoader loader, Profile profile, String location, String loadProfile) {
            try {
                Resource resource = this.resourceLoader.getResource(location);
                String description = this.getDescription(location, resource);
                if (profile != null) {
                    description = description + " for profile " + profile;
                }
                if (resource == null || !resource.exists()) {
                    this.logger.trace((Object)("Skipped missing config " + description));
                    return;
                }
                if (!StringUtils.hasText((String)StringUtils.getFilenameExtension((String)resource.getFilename()))) {
                    this.logger.trace((Object)("Skipped empty config extension " + description));
                    return;
                }
                String name = "applicationConfig: [" + location + "]" + (loadProfile == null ? "" : "#" + loadProfile);
                PropertySource<?> loaded = loader.load(name, resource, loadProfile, arg_0 -> ((ConfigurableEnvironment)this.environment).acceptsProfiles(arg_0));
                if (loaded == null) {
                    this.logger.trace((Object)("Skipped unloaded config " + description));
                    return;
                }
                this.handleProfileProperties(loaded);
                this.loaded.computeIfAbsent(profile, k -> new MutablePropertySources()).addLast(loaded);
                this.logger.debug((Object)("Loaded config file " + description));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to load property source from location '" + location + "'", ex);
            }
        }

        private String getDescription(String location, Resource resource) {
            try {
                if (resource != null) {
                    String uri = resource.getURI().toASCIIString();
                    return String.format("'%s' (%s)", uri, location);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return String.format("'%s'", location);
        }

        private void handleProfileProperties(PropertySource<?> propertySource) {
            Binder binder = new Binder(ConfigurationPropertySources.from(propertySource), new PropertySourcesPlaceholdersResolver((Environment)this.environment));
            Set<Profile> active = this.getProfiles(binder, ConfigFileApplicationListener.ACTIVE_PROFILES_PROPERTY);
            Set<Profile> include = this.getProfiles(binder, ConfigFileApplicationListener.INCLUDE_PROFILES_PROPERTY);
            this.maybeActivateProfiles(active);
            this.addProfiles(include);
        }

        private Set<Profile> getProfiles(Binder binder, String name) {
            return binder.bind(name, String[].class).map(this::asProfileSet).orElse(Collections.emptySet());
        }

        private Set<Profile> asProfileSet(String[] profileNames) {
            ArrayList<Profile> profiles = new ArrayList<Profile>();
            for (String profileName : profileNames) {
                profiles.add(new Profile(profileName));
            }
            Collections.reverse(profiles);
            return new LinkedHashSet<Profile>(profiles);
        }

        private void maybeActivateProfiles(Set<Profile> profiles) {
            if (profiles.isEmpty()) {
                return;
            }
            if (this.activatedProfiles) {
                this.logger.debug((Object)("Profiles already activated, '" + profiles + "' will not be applied"));
                return;
            }
            this.addProfiles(profiles);
            this.logger.debug((Object)("Activated profiles " + StringUtils.collectionToCommaDelimitedString(profiles)));
            this.activatedProfiles = true;
            this.removeUnprocessedDefaultProfiles();
        }

        private void removeUnprocessedDefaultProfiles() {
            this.profiles.removeIf(Profile::isDefaultProfile);
        }

        private void addProfiles(Set<Profile> profiles) {
            for (Profile profile : profiles) {
                this.profiles.add(profile);
                if (this.environmentHasActiveProfile(profile.getName())) continue;
                this.prependProfile(this.environment, profile);
            }
        }

        private boolean environmentHasActiveProfile(String profile) {
            for (String activeProfile : this.environment.getActiveProfiles()) {
                if (!activeProfile.equals(profile)) continue;
                return true;
            }
            return false;
        }

        private void prependProfile(ConfigurableEnvironment environment, Profile profile) {
            LinkedHashSet<String> profiles = new LinkedHashSet<String>();
            environment.getActiveProfiles();
            profiles.add(profile.getName());
            profiles.addAll(Arrays.asList(environment.getActiveProfiles()));
            environment.setActiveProfiles(profiles.toArray(new String[profiles.size()]));
        }

        private Set<String> getSearchLocations() {
            if (this.environment.containsProperty(ConfigFileApplicationListener.CONFIG_LOCATION_PROPERTY)) {
                return this.getSearchLocations(ConfigFileApplicationListener.CONFIG_LOCATION_PROPERTY);
            }
            Set<String> locations = this.getSearchLocations(ConfigFileApplicationListener.CONFIG_ADDITIONAL_LOCATION_PROPERTY);
            locations.addAll(this.asResolvedSet(ConfigFileApplicationListener.this.searchLocations, ConfigFileApplicationListener.DEFAULT_SEARCH_LOCATIONS));
            return locations;
        }

        private Set<String> getSearchLocations(String propertyName) {
            LinkedHashSet<String> locations = new LinkedHashSet<String>();
            if (this.environment.containsProperty(propertyName)) {
                for (String path : this.asResolvedSet(this.environment.getProperty(propertyName), null)) {
                    if (!path.contains("$") && !ResourceUtils.isUrl((String)(path = StringUtils.cleanPath((String)path)))) {
                        path = "file:" + path;
                    }
                    locations.add(path);
                }
            }
            return locations;
        }

        private Set<String> getSearchNames() {
            if (this.environment.containsProperty(ConfigFileApplicationListener.CONFIG_NAME_PROPERTY)) {
                String property = this.environment.getProperty(ConfigFileApplicationListener.CONFIG_NAME_PROPERTY);
                return this.asResolvedSet(property, null);
            }
            return this.asResolvedSet(ConfigFileApplicationListener.this.names, ConfigFileApplicationListener.DEFAULT_NAMES);
        }

        private Set<String> asResolvedSet(String value, String fallback) {
            List<String> list = Arrays.asList(StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)(value != null ? this.environment.resolvePlaceholders(value) : fallback))));
            Collections.reverse(list);
            return new LinkedHashSet<String>(list);
        }

        private void addLoadedPropertySources() {
            MutablePropertySources destination = this.environment.getPropertySources();
            String lastAdded = null;
            ArrayList<MutablePropertySources> loaded = new ArrayList<MutablePropertySources>(this.loaded.values());
            Collections.reverse(loaded);
            for (MutablePropertySources sources : loaded) {
                for (PropertySource source : sources) {
                    if (lastAdded == null) {
                        if (destination.contains(ConfigFileApplicationListener.DEFAULT_PROPERTIES)) {
                            destination.addBefore(ConfigFileApplicationListener.DEFAULT_PROPERTIES, source);
                        } else {
                            destination.addLast(source);
                        }
                    } else {
                        destination.addAfter(lastAdded, source);
                    }
                    lastAdded = source.getName();
                }
            }
        }
    }

    private class PropertySourceOrderingPostProcessor
    implements BeanFactoryPostProcessor,
    Ordered {
        private ConfigurableApplicationContext context;

        PropertySourceOrderingPostProcessor(ConfigurableApplicationContext context) {
            this.context = context;
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            this.reorderSources(this.context.getEnvironment());
        }

        private void reorderSources(ConfigurableEnvironment environment) {
            PropertySource defaultProperties = environment.getPropertySources().remove(ConfigFileApplicationListener.DEFAULT_PROPERTIES);
            if (defaultProperties != null) {
                environment.getPropertySources().addLast(defaultProperties);
            }
        }
    }
}

