/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.reactive;

import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class ApplicationContextServerWebExchangeMatcher<C>
implements ServerWebExchangeMatcher {
    private final Class<? extends C> contextClass;
    private volatile C context;
    private final Object contextLock = new Object();

    public ApplicationContextServerWebExchangeMatcher(Class<? extends C> contextClass) {
        Assert.notNull(contextClass, (String)"Context class must not be null");
        this.contextClass = contextClass;
    }

    public final Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange) {
        return this.matches(exchange, this.getContext(exchange));
    }

    protected abstract Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange var1, C var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected C getContext(ServerWebExchange exchange) {
        if (this.context == null) {
            Object object = this.contextLock;
            synchronized (object) {
                if (this.context == null) {
                    this.context = this.createContext(exchange);
                    this.initialized(this.context);
                }
            }
        }
        return this.context;
    }

    protected void initialized(C context) {
    }

    private C createContext(ServerWebExchange exchange) {
        ApplicationContext context = exchange.getApplicationContext();
        Assert.state((context != null ? 1 : 0) != 0, (String)"No WebApplicationContext found.");
        if (this.contextClass.isInstance(context)) {
            return (C)context;
        }
        try {
            return (C)context.getBean(this.contextClass);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return (C)context.getAutowireCapableBeanFactory().createBean(this.contextClass, 3, false);
        }
    }
}

