/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind.convert;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.boot.context.properties.bind.convert.DefaultDurationUnit;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class DurationConverter
implements GenericConverter {
    private static final Set<GenericConverter.ConvertiblePair> TYPES;
    private static final Pattern ISO8601;
    private static final Pattern SIMPLE;
    private static final Map<String, ChronoUnit> UNITS;

    DurationConverter() {
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return TYPES;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        return this.toDuration(source.toString(), (DefaultDurationUnit)targetType.getAnnotation(DefaultDurationUnit.class));
    }

    private Duration toDuration(String source, DefaultDurationUnit defaultUnit) {
        try {
            if (!StringUtils.hasLength((String)source)) {
                return null;
            }
            if (ISO8601.matcher(source).matches()) {
                return Duration.parse(source);
            }
            Matcher matcher = SIMPLE.matcher(source);
            Assert.state((boolean)matcher.matches(), () -> "'" + source + "' is not a valid duration");
            long amount = Long.parseLong(matcher.group(1));
            ChronoUnit unit = this.getUnit(matcher.group(2), defaultUnit);
            return Duration.of(amount, unit);
        }
        catch (Exception ex) {
            throw new IllegalStateException("'" + source + "' is not a valid duration", ex);
        }
    }

    private ChronoUnit getUnit(String value, DefaultDurationUnit defaultUnit) {
        if (StringUtils.isEmpty((Object)value)) {
            return defaultUnit != null ? defaultUnit.value() : ChronoUnit.MILLIS;
        }
        ChronoUnit unit = UNITS.get(value.toLowerCase());
        Assert.state((unit != null ? 1 : 0) != 0, () -> "Unknown unit '" + value + "'");
        return unit;
    }

    static {
        LinkedHashSet<GenericConverter.ConvertiblePair> types = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        types.add(new GenericConverter.ConvertiblePair(String.class, Duration.class));
        types.add(new GenericConverter.ConvertiblePair(Integer.class, Duration.class));
        TYPES = Collections.unmodifiableSet(types);
        ISO8601 = Pattern.compile("^[\\+\\-]?P.*$");
        SIMPLE = Pattern.compile("^([\\+\\-]?\\d+)([a-zA-Z]{0,2})$");
        LinkedHashMap<String, ChronoUnit> units = new LinkedHashMap<String, ChronoUnit>();
        units.put("ns", ChronoUnit.NANOS);
        units.put("ms", ChronoUnit.MILLIS);
        units.put("s", ChronoUnit.SECONDS);
        units.put("m", ChronoUnit.MINUTES);
        units.put("h", ChronoUnit.HOURS);
        units.put("d", ChronoUnit.DAYS);
        UNITS = Collections.unmodifiableMap(units);
    }
}

