/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.boot.context.properties.source.DefaultPropertyMapper;
import org.springframework.boot.context.properties.source.PropertyMapper;
import org.springframework.boot.context.properties.source.PropertyMapping;
import org.springframework.boot.context.properties.source.SpringIterableConfigurationPropertySource;
import org.springframework.boot.context.properties.source.SystemEnvironmentPropertyMapper;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.PropertySourceOrigin;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.util.Assert;

class SpringConfigurationPropertySource
implements ConfigurationPropertySource {
    private static final ConfigurationPropertyName RANDOM = ConfigurationPropertyName.of("random");
    private final PropertySource<?> propertySource;
    private final PropertyMapper mapper;
    private final Function<ConfigurationPropertyName, ConfigurationPropertyState> containsDescendantOf;

    SpringConfigurationPropertySource(PropertySource<?> propertySource, PropertyMapper mapper, Function<ConfigurationPropertyName, ConfigurationPropertyState> containsDescendantOf) {
        Assert.notNull(propertySource, (String)"PropertySource must not be null");
        Assert.notNull((Object)mapper, (String)"Mapper must not be null");
        this.propertySource = propertySource;
        this.mapper = new ExceptionSwallowingPropertyMapper(mapper);
        this.containsDescendantOf = containsDescendantOf != null ? containsDescendantOf : n -> ConfigurationPropertyState.UNKNOWN;
    }

    @Override
    public ConfigurationProperty getConfigurationProperty(ConfigurationPropertyName name) {
        List<PropertyMapping> mappings = this.getMapper().map(this.getPropertySource(), name);
        return this.find(mappings, name);
    }

    @Override
    public ConfigurationPropertyState containsDescendantOf(ConfigurationPropertyName name) {
        return this.containsDescendantOf.apply(name);
    }

    @Override
    public Object getUnderlyingSource() {
        return this.propertySource;
    }

    protected final ConfigurationProperty find(List<PropertyMapping> mappings, ConfigurationPropertyName name) {
        return mappings.stream().filter((? super T m) -> m.isApplicable(name)).map(this::find).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private ConfigurationProperty find(PropertyMapping mapping) {
        String propertySourceName = mapping.getPropertySourceName();
        Object value = this.getPropertySource().getProperty(propertySourceName);
        if (value == null) {
            return null;
        }
        value = mapping.getValueExtractor().apply(value);
        ConfigurationPropertyName configurationPropertyName = mapping.getConfigurationPropertyName();
        Origin origin = PropertySourceOrigin.get(this.propertySource, propertySourceName);
        return ConfigurationProperty.of(configurationPropertyName, value, origin);
    }

    protected PropertySource<?> getPropertySource() {
        return this.propertySource;
    }

    protected final PropertyMapper getMapper() {
        return this.mapper;
    }

    public String toString() {
        return this.propertySource.toString();
    }

    public static SpringConfigurationPropertySource from(PropertySource<?> source) {
        Assert.notNull(source, (String)"Source must not be null");
        PropertyMapper mapper = SpringConfigurationPropertySource.getPropertyMapper(source);
        if (SpringConfigurationPropertySource.isFullEnumerable(source)) {
            return new SpringIterableConfigurationPropertySource((EnumerablePropertySource)source, mapper);
        }
        return new SpringConfigurationPropertySource(source, mapper, SpringConfigurationPropertySource.getContainsDescendantOfForSource(source));
    }

    private static PropertyMapper getPropertyMapper(PropertySource<?> source) {
        if (source instanceof SystemEnvironmentPropertySource && SpringConfigurationPropertySource.hasSystemEnvironmentName(source)) {
            return SystemEnvironmentPropertyMapper.INSTANCE;
        }
        return DefaultPropertyMapper.INSTANCE;
    }

    private static boolean hasSystemEnvironmentName(PropertySource<?> source) {
        String name = source.getName();
        return "systemEnvironment".equals(name) || name.endsWith("-systemEnvironment");
    }

    private static boolean isFullEnumerable(PropertySource<?> source) {
        PropertySource<?> rootSource = SpringConfigurationPropertySource.getRootSource(source);
        if (rootSource.getSource() instanceof Map) {
            try {
                ((Map)rootSource.getSource()).size();
            }
            catch (UnsupportedOperationException ex) {
                return false;
            }
        }
        return source instanceof EnumerablePropertySource;
    }

    private static PropertySource<?> getRootSource(PropertySource<?> source) {
        while (source.getSource() != null && source.getSource() instanceof PropertySource) {
            source = (PropertySource)source.getSource();
        }
        return source;
    }

    private static Function<ConfigurationPropertyName, ConfigurationPropertyState> getContainsDescendantOfForSource(PropertySource<?> source) {
        if (source.getSource() instanceof Random) {
            return SpringConfigurationPropertySource::containsDescendantOfForRandom;
        }
        return null;
    }

    private static ConfigurationPropertyState containsDescendantOfForRandom(ConfigurationPropertyName name) {
        if (name.isAncestorOf(RANDOM) || name.equals(RANDOM)) {
            return ConfigurationPropertyState.PRESENT;
        }
        return ConfigurationPropertyState.ABSENT;
    }

    private static class ExceptionSwallowingPropertyMapper
    implements PropertyMapper {
        private final PropertyMapper mapper;

        ExceptionSwallowingPropertyMapper(PropertyMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        public List<PropertyMapping> map(PropertySource<?> propertySource, ConfigurationPropertyName configurationPropertyName) {
            try {
                return this.mapper.map(propertySource, configurationPropertyName);
            }
            catch (Exception ex) {
                return Collections.emptyList();
            }
        }

        @Override
        public List<PropertyMapping> map(PropertySource<?> propertySource, String propertySourceName) {
            try {
                return this.mapper.map(propertySource, propertySourceName);
            }
            catch (Exception ex) {
                return Collections.emptyList();
            }
        }
    }
}

