/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet.server;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;

class StaticResourceJars {
    StaticResourceJars() {
    }

    public final List<URL> getUrls() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ArrayList<URL> urls = new ArrayList<URL>();
        if (classLoader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                this.addUrl(urls, url);
            }
        } else {
            for (String entry : ManagementFactory.getRuntimeMXBean().getClassPath().split(File.pathSeparator)) {
                this.addUrl(urls, this.toUrl(entry));
            }
        }
        return urls;
    }

    private URL toUrl(String classPathEntry) {
        try {
            return new File(classPathEntry).toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("URL could not be created from '" + classPathEntry + "'", ex);
        }
    }

    private void addUrl(List<URL> urls, URL url) {
        try {
            if ("file".equals(url.getProtocol())) {
                this.addUrlFile(urls, url, new File(url.getFile()));
            } else {
                this.addUrlConnection(urls, url, url.openConnection());
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void addUrlFile(List<URL> urls, URL url, File file) {
        if (file.isDirectory() && new File(file, "META-INF/resources").isDirectory()) {
            urls.add(url);
        } else if (this.isResourcesJar(file)) {
            urls.add(url);
        }
    }

    private void addUrlConnection(List<URL> urls, URL url, URLConnection connection) {
        if (connection instanceof JarURLConnection && this.isResourcesJar((JarURLConnection)connection)) {
            urls.add(url);
        }
    }

    private boolean isResourcesJar(JarURLConnection connection) {
        try {
            return this.isResourcesJar(connection.getJarFile());
        }
        catch (IOException ex) {
            return false;
        }
    }

    private boolean isResourcesJar(File file) {
        try {
            return this.isResourcesJar(new JarFile(file));
        }
        catch (IOException ex) {
            return false;
        }
    }

    private boolean isResourcesJar(JarFile jar) throws IOException {
        try {
            boolean bl = jar.getName().endsWith(".jar") && jar.getJarEntry("META-INF/resources") != null;
            return bl;
        }
        finally {
            jar.close();
        }
    }
}

