/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinder;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.boot.validation.MessageInterpolatorFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

class ValidatedLocalValidatorFactoryBean
extends LocalValidatorFactoryBean
implements ConfigurationPropertiesBinder.InternalValidator {
    private static final Log logger = LogFactory.getLog(ConfigurationPropertiesBindingPostProcessor.class);

    ValidatedLocalValidatorFactoryBean(ApplicationContext applicationContext) {
        this.setApplicationContext(applicationContext);
        this.setMessageInterpolator(new MessageInterpolatorFactory().getObject());
        this.afterPropertiesSet();
    }

    public boolean supports(Class<?> type) {
        if (!super.supports(type)) {
            return false;
        }
        if (AnnotatedElementUtils.hasAnnotation(type, Validated.class)) {
            return true;
        }
        if (type.getPackage() != null && type.getPackage().getName().startsWith("org.springframework.boot")) {
            return false;
        }
        if (this.getConstraintsForClass(type).isBeanConstrained()) {
            logger.warn((Object)("The @ConfigurationProperties bean " + type + " contains validation constraints but had not been annotated with @Validated."));
        }
        return true;
    }
}

