/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.netty;

import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.BiFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.server.PortInUseException;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import reactor.ipc.netty.http.HttpResources;
import reactor.ipc.netty.http.server.HttpServer;
import reactor.ipc.netty.tcp.BlockingNettyContext;

public class NettyWebServer
implements WebServer {
    private static final Log logger = LogFactory.getLog(NettyWebServer.class);
    private final ReactorHttpHandlerAdapter handlerAdapter;
    private final HttpServer reactorServer;
    private BlockingNettyContext nettyContext;

    public NettyWebServer(HttpServer reactorServer, ReactorHttpHandlerAdapter handlerAdapter) {
        this.reactorServer = reactorServer;
        this.handlerAdapter = handlerAdapter;
    }

    @Override
    public void start() throws WebServerException {
        if (this.nettyContext == null) {
            try {
                this.nettyContext = this.reactorServer.start((BiFunction)this.handlerAdapter);
            }
            catch (Exception ex) {
                SocketAddress address;
                if (this.findBindException(ex) != null && (address = this.reactorServer.options().getAddress()) instanceof InetSocketAddress) {
                    throw new PortInUseException(((InetSocketAddress)address).getPort());
                }
                throw new WebServerException("Unable to start Netty", ex);
            }
            logger.info((Object)("Netty started on port(s): " + this.getPort()));
            this.startDaemonAwaitThread(this.nettyContext);
        }
    }

    private BindException findBindException(Exception ex) {
        for (Throwable candidate = ex; candidate != null; candidate = candidate.getCause()) {
            if (!(candidate instanceof BindException)) continue;
            return (BindException)candidate;
        }
        return null;
    }

    private void startDaemonAwaitThread(final BlockingNettyContext nettyContext) {
        Thread awaitThread = new Thread("server"){

            @Override
            public void run() {
                nettyContext.getContext().onClose().block();
            }
        };
        awaitThread.setContextClassLoader(this.getClass().getClassLoader());
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    @Override
    public void stop() throws WebServerException {
        if (this.nettyContext != null) {
            this.nettyContext.shutdown();
            this.nettyContext.getContext().onClose().doOnSuccess(o -> HttpResources.reset()).block();
            this.nettyContext = null;
        }
    }

    @Override
    public int getPort() {
        if (this.nettyContext != null) {
            return this.nettyContext.getPort();
        }
        return 0;
    }
}

