/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.bind.AggregateElementBinder;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.IndexedElementsBinder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.core.ResolvableType;

class ArrayBinder
extends IndexedElementsBinder<Object> {
    ArrayBinder(BindContext context) {
        super(context);
    }

    @Override
    protected Object bind(ConfigurationPropertyName name, Bindable<?> target, AggregateElementBinder elementBinder, Class<?> type) {
        IndexedElementsBinder.IndexedCollectionSupplier collection = new IndexedElementsBinder.IndexedCollectionSupplier(ArrayList::new);
        ResolvableType elementType = target.getType().getComponentType();
        this.bindIndexed(name, target, elementBinder, collection, target.getType(), elementType);
        if (collection.wasSupplied()) {
            List list = (List)collection.get();
            Object array = Array.newInstance(elementType.resolve(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(array, i, list.get(i));
            }
            return array;
        }
        return null;
    }

    @Override
    protected Object merge(Object existing, Object additional) {
        return additional;
    }
}

