/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import groovy.lang.Closure;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.groovy.GroovyBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.filter.AbstractTypeHierarchyTraversingFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class BeanDefinitionLoader {
    private static final ResourceLoader DEFAULT_RESOURCE_LOADER = new PathMatchingResourcePatternResolver();
    private final Object[] sources;
    private final AnnotatedBeanDefinitionReader annotatedReader;
    private final XmlBeanDefinitionReader xmlReader;
    private GroovyBeanDefinitionReader groovyReader;
    private final ClassPathBeanDefinitionScanner scanner;
    private ResourceLoader resourceLoader;

    public BeanDefinitionLoader(BeanDefinitionRegistry registry, Object ... sources) {
        Assert.notNull((Object)registry, (String)"Registry must not be null");
        Assert.notEmpty((Object[])sources, (String)"Sources must not be empty");
        this.sources = sources;
        this.annotatedReader = new AnnotatedBeanDefinitionReader(registry);
        this.xmlReader = new XmlBeanDefinitionReader(registry);
        if (this.isGroovyPresent()) {
            this.groovyReader = new GroovyBeanDefinitionReader(registry);
        }
        this.scanner = new ClassPathBeanDefinitionScanner(registry);
        this.scanner.addExcludeFilter((TypeFilter)new ClassExcludeFilter(sources));
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.annotatedReader.setBeanNameGenerator(beanNameGenerator);
        this.xmlReader.setBeanNameGenerator(beanNameGenerator);
        this.scanner.setBeanNameGenerator(beanNameGenerator);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.xmlReader.setResourceLoader(resourceLoader);
        this.scanner.setResourceLoader(resourceLoader);
    }

    public void setEnvironment(ConfigurableEnvironment environment) {
        this.annotatedReader.setEnvironment((Environment)environment);
        this.xmlReader.setEnvironment((Environment)environment);
        this.scanner.setEnvironment((Environment)environment);
    }

    public int load() {
        int count = 0;
        for (Object source : this.sources) {
            count += this.load(source);
        }
        return count;
    }

    private int load(Object source) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        if (source instanceof Class) {
            return this.load((Class)source);
        }
        if (source instanceof Resource) {
            return this.load((Resource)source);
        }
        if (source instanceof Package) {
            return this.load((Package)source);
        }
        if (source instanceof CharSequence) {
            return this.load((CharSequence)source);
        }
        throw new IllegalArgumentException("Invalid source type " + source.getClass());
    }

    private int load(Class<?> source) {
        if (this.isGroovyPresent() && GroovyBeanDefinitionSource.class.isAssignableFrom(source)) {
            GroovyBeanDefinitionSource loader = (GroovyBeanDefinitionSource)BeanUtils.instantiateClass(source, GroovyBeanDefinitionSource.class);
            this.load(loader);
        }
        if (this.isComponent(source)) {
            this.annotatedReader.register(new Class[]{source});
            return 1;
        }
        return 0;
    }

    private int load(GroovyBeanDefinitionSource source) {
        int before = this.xmlReader.getRegistry().getBeanDefinitionCount();
        this.groovyReader.beans(source.getBeans());
        int after = this.xmlReader.getRegistry().getBeanDefinitionCount();
        return after - before;
    }

    private int load(Resource source) {
        if (source.getFilename().endsWith(".groovy")) {
            if (this.groovyReader == null) {
                throw new BeanDefinitionStoreException("Cannot load Groovy beans without Groovy on classpath");
            }
            return this.groovyReader.loadBeanDefinitions(source);
        }
        return this.xmlReader.loadBeanDefinitions(source);
    }

    private int load(Package source) {
        return this.scanner.scan(new String[]{source.getName()});
    }

    private int load(CharSequence source) {
        String resolvedSource = this.xmlReader.getEnvironment().resolvePlaceholders(source.toString());
        try {
            return this.load(ClassUtils.forName((String)resolvedSource, null));
        }
        catch (IllegalArgumentException ex) {
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        Resource[] resources = this.findResources(resolvedSource);
        int loadCount = 0;
        boolean atLeastOneResourceExists = false;
        for (Resource resource : resources) {
            if (resource == null || !resource.exists()) continue;
            atLeastOneResourceExists = true;
            loadCount += this.load(resource);
        }
        if (atLeastOneResourceExists) {
            return loadCount;
        }
        Package packageResource = this.findPackage(resolvedSource);
        if (packageResource != null) {
            return this.load(packageResource);
        }
        throw new IllegalArgumentException("Invalid source '" + resolvedSource + "'");
    }

    private boolean isGroovyPresent() {
        return ClassUtils.isPresent((String)"groovy.lang.MetaClass", null);
    }

    private Resource[] findResources(String source) {
        ResourceLoader loader = this.resourceLoader != null ? this.resourceLoader : DEFAULT_RESOURCE_LOADER;
        try {
            if (loader instanceof ResourcePatternResolver) {
                return ((ResourcePatternResolver)loader).getResources(source);
            }
            return new Resource[]{loader.getResource(source)};
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error reading source '" + source + "'");
        }
    }

    private Package findPackage(CharSequence source) {
        Package pkg = Package.getPackage(source.toString());
        if (pkg != null) {
            return pkg;
        }
        try {
            Resource[] resources;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.getClass().getClassLoader());
            Resource[] arr$ = resources = resolver.getResources(ClassUtils.convertClassNameToResourcePath((String)source.toString()) + "/*.class");
            int len$ = arr$.length;
            int i$ = 0;
            if (i$ < len$) {
                Resource resource = arr$[i$];
                String className = StringUtils.stripFilenameExtension((String)resource.getFilename());
                this.load(Class.forName(source.toString() + "." + className));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Package.getPackage(source.toString());
    }

    private boolean isComponent(Class<?> type) {
        if (AnnotationUtils.findAnnotation(type, Component.class) != null) {
            return true;
        }
        return !type.isAnonymousClass() && !type.getName().matches(".*\\$_.*closure.*") && type.getConstructors() != null && type.getConstructors().length != 0;
    }

    protected static interface GroovyBeanDefinitionSource {
        public Closure<?> getBeans();
    }

    private static class ClassExcludeFilter
    extends AbstractTypeHierarchyTraversingFilter {
        private final Set<String> classNames = new HashSet<String>();

        public ClassExcludeFilter(Object ... sources) {
            super(false, false);
            for (Object source : sources) {
                if (!(source instanceof Class)) continue;
                this.classNames.add(((Class)source).getName());
            }
        }

        protected boolean matchClassName(String className) {
            return this.classNames.contains(className);
        }
    }
}

