/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.liquibase;

import java.io.IOException;
import java.util.Set;
import liquibase.servicelocator.DefaultPackageScanClassResolver;
import liquibase.servicelocator.PackageScanFilter;
import org.springframework.boot.liquibase.LiquibaseServiceLocatorInitializer;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ClassUtils;

public class SpringPackageScanClassResolver
extends DefaultPackageScanClassResolver {
    protected void find(PackageScanFilter test, String packageName, ClassLoader loader, Set<Class<?>> classes) {
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory(loader);
        try {
            Resource[] resources;
            for (Resource resource : resources = this.scan(loader, packageName)) {
                Class<?> candidate = this.loadClass(loader, (MetadataReaderFactory)metadataReaderFactory, resource);
                if (candidate == null || !test.matches(candidate)) continue;
                classes.add(candidate);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Resource[] scan(ClassLoader loader, String packageName) throws IOException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(loader);
        String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packageName) + "/**/*.class";
        Resource[] resources = resolver.getResources(pattern);
        return resources;
    }

    private Class<?> loadClass(ClassLoader loader, MetadataReaderFactory readerFactory, Resource resource) {
        try {
            MetadataReader reader = readerFactory.getMetadataReader(resource);
            return ClassUtils.forName((String)reader.getClassMetadata().getClassName(), (ClassLoader)loader);
        }
        catch (Exception ex) {
            if (LiquibaseServiceLocatorInitializer.logger.isWarnEnabled()) {
                LiquibaseServiceLocatorInitializer.logger.warn((Object)("Ignoring cadidate class resource " + resource), (Throwable)ex);
            }
            return null;
        }
    }
}

