/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplicationEnvironmentAvailableEvent;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.PropertyResolver;

public class FileEncodingApplicationListener
implements ApplicationListener<SpringApplicationEnvironmentAvailableEvent> {
    private static Log logger = LogFactory.getLog(FileEncodingApplicationListener.class);

    public void onApplicationEvent(SpringApplicationEnvironmentAvailableEvent event) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)event.getEnvironment(), "spring.");
        if (resolver.containsProperty("mandatoryFileEncoding")) {
            String encoding = System.getProperty("file.encoding");
            String desired = resolver.getProperty("mandatoryFileEncoding");
            if (encoding != null && !desired.equalsIgnoreCase(encoding)) {
                logger.error((Object)("System property 'file.encoding' is currently '" + encoding + "'. It should be '" + desired + "' (as defined in 'spring.mandatoryFileEncoding')."));
                logger.error((Object)("Environment variable LANG is '" + System.getenv("LANG") + "'. You could use a locale setting that matches encoding='" + desired + "'."));
                logger.error((Object)("Environment variable LC_ALL is '" + System.getenv("LC_ALL") + "'. You could use a locale setting that matches encoding='" + desired + "'."));
                throw new IllegalStateException("The Java Virtual Machine has not  been configured to use the desired default character encoding (" + desired + ").");
            }
        }
    }
}

