/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationEnvironmentAvailableEvent;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.boot.config.PropertiesPropertySourceLoader;
import org.springframework.boot.config.PropertySourceLoader;
import org.springframework.boot.config.YamlPropertySourceLoader;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

public class ConfigFileApplicationListener
implements ApplicationListener<SpringApplicationEnvironmentAvailableEvent>,
Ordered {
    private static final String LOCATION_VARIABLE = "${spring.config.location}";
    private String[] searchLocations = new String[]{"classpath:", "file:./", "classpath:config/", "file:./config/"};
    private String names = "${spring.config.name:application}";
    private int order = -2147483638;
    private final Map<String, org.springframework.core.env.PropertySource<?>> cached = new HashMap();
    private final ConversionService conversionService = new DefaultConversionService();
    private final PropertySourceAnnotations propertySourceAnnotations = new PropertySourceAnnotations();
    private PropertySourceLoaderFactory propertySourceLoaderFactory = new DefaultPropertySourceLoaderFactory();

    public void onApplicationEvent(SpringApplicationEnvironmentAvailableEvent event) {
        ConfigurableEnvironment created = event.getEnvironment();
        if (created instanceof ConfigurableEnvironment) {
            SpringApplication springApplication = event.getSpringApplication();
            this.extractPropertySources(springApplication.getSources());
            ConfigurableEnvironment environment = created;
            this.load(environment, (ResourceLoader)new DefaultResourceLoader());
            environment.getPropertySources().addAfter("systemEnvironment", (org.springframework.core.env.PropertySource)new RandomValuePropertySource("random"));
            int before = springApplication.getSources().size();
            PropertySourcesPropertyValues propertyValues = new PropertySourcesPropertyValues((org.springframework.core.env.PropertySources)environment.getPropertySources());
            RelaxedDataBinder binder = new RelaxedDataBinder(springApplication, "spring.main");
            binder.setConversionService(this.conversionService);
            binder.bind(propertyValues);
            int after = springApplication.getSources().size();
            if (after > before) {
                this.onApplicationEvent(event);
            }
        }
    }

    private void extractPropertySources(Set<Object> sources) {
        for (Object source : sources) {
            if (!(source instanceof Class)) continue;
            Class type = (Class)source;
            for (AnnotationAttributes propertySource : ConfigFileApplicationListener.attributesForRepeatable((AnnotationMetadata)new StandardAnnotationMetadata(type), PropertySources.class, PropertySource.class)) {
                this.propertySourceAnnotations.add(type, propertySource.getStringArray("value"), propertySource.getBoolean("ignoreResourceNotFound"), propertySource.getString("name"));
            }
        }
    }

    static Set<AnnotationAttributes> attributesForRepeatable(AnnotationMetadata metadata, Class<?> containerClass, Class<?> annotationClass) {
        LinkedHashSet<AnnotationAttributes> result = new LinkedHashSet<AnnotationAttributes>();
        ConfigFileApplicationListener.addAttributesIfNotNull(result, metadata.getAnnotationAttributes(annotationClass.getName(), false));
        Map container = metadata.getAnnotationAttributes(containerClass.getName(), false);
        if (container != null && container.containsKey("value")) {
            for (Map containedAttributes : (Map[])container.get("value")) {
                ConfigFileApplicationListener.addAttributesIfNotNull(result, containedAttributes);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private static void addAttributesIfNotNull(Set<AnnotationAttributes> result, Map<String, Object> attributes) {
        if (attributes != null) {
            result.add(AnnotationAttributes.fromMap(attributes));
        }
    }

    private void load(ConfigurableEnvironment environment, ResourceLoader resourceLoader) {
        List<String> candidates = this.getCandidateLocations(resourceLoader);
        Collections.reverse(candidates);
        org.springframework.core.env.PropertySource removed = environment.getPropertySources().remove("defaultProperties");
        String first = null;
        for (String candidate : candidates) {
            org.springframework.core.env.PropertySource<?> source = this.load(environment, resourceLoader, candidate, null);
            if (source == null) continue;
            if (first == null) {
                first = source.getName();
            }
            environment.getPropertySources().addLast(source);
        }
        if (environment.containsProperty("spring.profiles.active")) {
            Set profiles = StringUtils.commaDelimitedListToSet((String)environment.getProperty("spring.profiles.active").toString());
            for (String active : profiles) {
                environment.addActiveProfile(active);
            }
        }
        for (String profile : environment.getActiveProfiles()) {
            for (String candidate : candidates) {
                org.springframework.core.env.PropertySource<?> source = this.load(environment, resourceLoader, candidate, profile);
                if (source == null) continue;
                if (first != null) {
                    environment.getPropertySources().addBefore(first, source);
                    continue;
                }
                environment.getPropertySources().addLast(source);
            }
        }
        if (removed != null) {
            environment.getPropertySources().addLast(removed);
        }
    }

    private List<String> getCandidateLocations(ResourceLoader resourceLoader) {
        LinkedHashSet<String> candidates = new LinkedHashSet<String>();
        for (String searchLocation : this.searchLocations) {
            for (String extension : new String[]{".properties", ".yml"}) {
                for (String name : StringUtils.commaDelimitedListToStringArray((String)this.names)) {
                    String location = searchLocation + name + extension;
                    candidates.add(location);
                }
            }
        }
        candidates.add(LOCATION_VARIABLE);
        for (String location : this.propertySourceAnnotations.locations()) {
            Resource resource = resourceLoader.getResource(location);
            if (!this.propertySourceAnnotations.ignoreResourceNotFound(location) && !resource.exists()) {
                throw new IllegalStateException("Resource not found: " + location);
            }
            candidates.add(location);
        }
        return new ArrayList<String>(candidates);
    }

    private org.springframework.core.env.PropertySource<?> load(ConfigurableEnvironment environment, ResourceLoader resourceLoader, String location, String profile) {
        org.springframework.core.env.PropertySource<?> propertySource;
        String path = environment.resolvePlaceholders(location);
        if (LOCATION_VARIABLE.equals(location) && !path.contains("$")) {
            if (!path.contains(":")) {
                path = "file:" + path;
            }
            path = StringUtils.cleanPath((String)path);
        }
        location = path;
        String suffix = "." + StringUtils.getFilenameExtension((String)location);
        Class<?> type = this.propertySourceAnnotations.configuration(location);
        if (StringUtils.hasLength((String)profile)) {
            location = location.replace(suffix, "-" + profile + suffix);
        }
        if (this.isPropertySourceAnnotationOnExcludedType((Environment)environment, profile, type, location)) {
            return null;
        }
        List<PropertySourceLoader> loaders = this.propertySourceLoaderFactory.getLoaders((Environment)environment);
        Resource resource = resourceLoader.getResource(location);
        String name = this.propertySourceAnnotations.name(location);
        if (name == null) {
            name = location;
        }
        if ((propertySource = this.getPropertySource(name, resource, profile, loaders)) == null) {
            return null;
        }
        return propertySource;
    }

    private boolean isPropertySourceAnnotationOnExcludedType(Environment environment, String profile, Class<?> type, String location) {
        if (type == null) {
            return false;
        }
        if (StringUtils.hasText((String)profile) && !this.propertySourceAnnotations.locations().contains(location)) {
            return true;
        }
        AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)new DefaultListableBeanFactory(), environment);
        int before = reader.getRegistry().getBeanDefinitionCount();
        reader.register(new Class[]{type});
        int after = reader.getRegistry().getBeanDefinitionCount();
        return after == before;
    }

    private org.springframework.core.env.PropertySource<?> getPropertySource(String name, Resource resource, String profile, List<PropertySourceLoader> loaders) {
        if (resource == null || !resource.exists()) {
            return null;
        }
        String key = resource.getDescription() + (profile == null ? "" : "#" + profile);
        if (this.cached.containsKey(key)) {
            return this.cached.get(key);
        }
        boolean satisfied = true;
        for (PropertySourceLoader loader : loaders) {
            if (loader.supports(resource)) {
                org.springframework.core.env.PropertySource<?> propertySource = loader.load(name, resource);
                this.cached.put(key, propertySource);
                return propertySource;
            }
            satisfied = false;
        }
        if (!satisfied) {
            throw new IllegalStateException("No supported loader found for configuration resource: " + resource);
        }
        return null;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setNames(String names) {
        this.names = names;
    }

    public void setSearchLocations(String[] searchLocations) {
        this.searchLocations = searchLocations == null ? null : (String[])searchLocations.clone();
    }

    public void setPropertySourceLoaderFactory(PropertySourceLoaderFactory propertySourceLoaderFactory) {
        this.propertySourceLoaderFactory = propertySourceLoaderFactory;
    }

    private static class DefaultPropertySourceLoaderFactory
    implements PropertySourceLoaderFactory {
        private DefaultPropertySourceLoaderFactory() {
        }

        @Override
        public List<PropertySourceLoader> getLoaders(Environment environment) {
            ArrayList<PropertySourceLoader> loaders = new ArrayList<PropertySourceLoader>();
            loaders.add(new PropertiesPropertySourceLoader());
            if (ClassUtils.isPresent((String)"org.yaml.snakeyaml.Yaml", null)) {
                loaders.add(YamlPropertySourceLoader.springProfileAwareLoader(environment.getActiveProfiles()));
            }
            return loaders;
        }
    }

    public static interface PropertySourceLoaderFactory {
        public List<PropertySourceLoader> getLoaders(Environment var1);
    }

    private static class PropertySourceAnnotations {
        private final Collection<String> locations = new LinkedHashSet<String>();
        private final Map<String, String> names = new HashMap<String, String>();
        private final Map<String, Class<?>> configs = new HashMap();
        private final Map<String, Boolean> ignores = new HashMap<String, Boolean>();

        private PropertySourceAnnotations() {
        }

        public void add(Class<?> source, String[] locations, boolean ignoreResourceNotFound, String name) {
            this.locations.addAll(Arrays.asList(locations));
            if (StringUtils.hasText((String)name)) {
                for (String location : locations) {
                    this.names.put(location, name);
                }
            }
            for (String location : locations) {
                boolean reallyIgnore = ignoreResourceNotFound;
                if (this.ignores.containsKey(location)) {
                    reallyIgnore &= this.ignores.get(location).booleanValue();
                }
                this.ignores.put(location, reallyIgnore);
                this.configs.put(location, source);
            }
        }

        public Class<?> configuration(String location) {
            return this.configs.get(location);
        }

        public boolean ignoreResourceNotFound(String location) {
            return this.ignores.containsKey(location) ? this.ignores.get(location) : false;
        }

        public String name(String location) {
            String name = this.names.get(location);
            if (name == null || Collections.frequency(this.names.values(), name) > 1) {
                return null;
            }
            return "boot." + name;
        }

        public Collection<String> locations() {
            return this.locations;
        }
    }

    private static class RandomValuePropertySource
    extends org.springframework.core.env.PropertySource<Random> {
        public RandomValuePropertySource(String name) {
            super(name, (Object)new Random());
        }

        public Object getProperty(String name) {
            if (!name.startsWith("random.")) {
                return null;
            }
            if (name.endsWith("int")) {
                return ((Random)this.getSource()).nextInt();
            }
            if (name.endsWith("long")) {
                return ((Random)this.getSource()).nextLong();
            }
            byte[] bytes = new byte[32];
            ((Random)this.getSource()).nextBytes(bytes);
            return DigestUtils.md5DigestAsHex((byte[])bytes);
        }
    }
}

