/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.springframework.boot.context.embedded.RegistrationBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ServletListenerRegistrationBean<T extends EventListener>
extends RegistrationBean {
    private static final Set<Class<?>> SUPPORTED_TYPES;
    private T listener;

    public ServletListenerRegistrationBean() {
    }

    public ServletListenerRegistrationBean(T listener) {
        Assert.notNull(listener, (String)"Listener must not be null");
        Assert.isTrue((boolean)ServletListenerRegistrationBean.isSupportedType(listener), (String)"Listener is not of a supported type");
        this.listener = listener;
    }

    public void setListener(T listener) {
        Assert.notNull(listener, (String)"Listener must not be null");
        Assert.isTrue((boolean)ServletListenerRegistrationBean.isSupportedType(listener), (String)"Listener is not of a supported type");
        this.listener = listener;
    }

    @Override
    public void onStartup(ServletContext servletContext) throws ServletException {
        servletContext.addListener(this.listener);
    }

    public T getListener() {
        return this.listener;
    }

    public static boolean isSupportedType(EventListener listener) {
        for (Class<?> type : SUPPORTED_TYPES) {
            if (!ClassUtils.isAssignableValue(type, (Object)listener)) continue;
            return true;
        }
        return false;
    }

    public static Set<Class<?>> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    static {
        HashSet<Class> types = new HashSet<Class>();
        types.add(ServletContextAttributeListener.class);
        types.add(ServletRequestListener.class);
        types.add(ServletRequestAttributeListener.class);
        types.add(HttpSessionAttributeListener.class);
        types.add(HttpSessionListener.class);
        types.add(ServletContextListener.class);
        SUPPORTED_TYPES = Collections.unmodifiableSet(types);
    }
}

