/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.boot.Banner;
import org.springframework.boot.BeanDefinitionLoader;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplicationBeforeRefreshEvent;
import org.springframework.boot.SpringApplicationEnvironmentAvailableEvent;
import org.springframework.boot.SpringApplicationErrorEvent;
import org.springframework.boot.SpringApplicationStartEvent;
import org.springframework.boot.StartupInfoLogger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SimpleCommandLinePropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.StandardServletEnvironment;

public class SpringApplication {
    private static final String DEFAULT_CONTEXT_CLASS = "org.springframework.context.annotation.AnnotationConfigApplicationContext";
    public static final String DEFAULT_WEB_CONTEXT_CLASS = "org.springframework.boot.context.embedded.AnnotationConfigEmbeddedWebApplicationContext";
    private static final String[] WEB_ENVIRONMENT_CLASSES = new String[]{"javax.servlet.Servlet", "org.springframework.web.context.ConfigurableWebApplicationContext"};
    private final Log log = LogFactory.getLog(this.getClass());
    private final Set<Object> sources = new LinkedHashSet<Object>();
    private Class<?> mainApplicationClass;
    private boolean showBanner = true;
    private boolean logStartupInfo = true;
    private boolean addCommandLineProperties = true;
    private ResourceLoader resourceLoader;
    private BeanNameGenerator beanNameGenerator;
    private ConfigurableEnvironment environment;
    private Class<? extends ConfigurableApplicationContext> applicationContextClass;
    private boolean webEnvironment;
    private boolean headless = true;
    private Set<ApplicationContextInitializer<?>> initializers;
    private Set<ApplicationListener<?>> listeners;
    private Map<String, Object> defaultProperties;
    private Set<String> profiles = new HashSet<String>();

    public SpringApplication(Object ... sources) {
        this.initialize(sources);
    }

    public SpringApplication(ResourceLoader resourceLoader, Object ... sources) {
        this.resourceLoader = resourceLoader;
        this.initialize(sources);
    }

    private void initialize(Object[] sources) {
        if (sources != null && sources.length > 0) {
            this.sources.addAll(Arrays.asList(sources));
        }
        this.webEnvironment = this.deduceWebEnvironment();
        this.initializers = new LinkedHashSet();
        this.listeners = new LinkedHashSet();
        Collection<ApplicationContextInitializer> initializers = this.getSpringFactoriesInstances(ApplicationContextInitializer.class);
        this.initializers.addAll(initializers);
        for (ApplicationContextInitializer initializer : initializers) {
            if (!(initializer instanceof ApplicationListener)) continue;
            this.addListeners((ApplicationListener)initializer);
        }
        Collection<ApplicationListener> listeners = this.getSpringFactoriesInstances(ApplicationListener.class);
        this.listeners.addAll(listeners);
        for (ApplicationListener listener : listeners) {
            if (!(listener instanceof ApplicationContextInitializer)) continue;
            this.addInitializers((ApplicationContextInitializer)listener);
        }
        this.mainApplicationClass = this.deduceMainApplicationClass();
    }

    private boolean deduceWebEnvironment() {
        for (String className : WEB_ENVIRONMENT_CLASSES) {
            if (ClassUtils.isPresent((String)className, null)) continue;
            return false;
        }
        return true;
    }

    private <T> Collection<? extends T> getSpringFactoriesInstances(Class<T> type) {
        ClassLoader classLoader = SpringApplication.class.getClassLoader();
        LinkedHashSet names = new LinkedHashSet(SpringFactoriesLoader.loadFactoryNames(type, (ClassLoader)classLoader));
        ArrayList instances = new ArrayList(names.size());
        for (String name : names) {
            try {
                Class instanceClass = ClassUtils.forName((String)name, (ClassLoader)classLoader);
                Assert.isAssignable(type, (Class)instanceClass);
                Object instance = instanceClass.newInstance();
                instances.add(instance);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Cannot instantiate " + type + " : " + name, ex);
            }
        }
        AnnotationAwareOrderComparator.sort(instances);
        return instances;
    }

    private Class<?> deduceMainApplicationClass() {
        try {
            StackTraceElement[] stackTrace;
            for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
                if (!"main".equals(stackTraceElement.getMethodName())) continue;
                return Class.forName(stackTraceElement.getClassName());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public ConfigurableApplicationContext run(String ... args) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        ConfigurableApplicationContext context = null;
        System.setProperty("java.awt.headless", Boolean.toString(this.headless));
        ApplicationEventMulticaster multicaster = this.createApplicationEventMulticaster();
        try {
            Set<Object> sources = this.getSources();
            this.registerListeners(multicaster, sources);
            multicaster.multicastEvent((ApplicationEvent)new SpringApplicationStartEvent(this, args));
            ConfigurableEnvironment environment = this.getOrCreateEnvironment();
            this.addPropertySources(environment, args);
            for (String profile : this.profiles) {
                environment.addActiveProfile(profile);
            }
            multicaster.multicastEvent((ApplicationEvent)new SpringApplicationEnvironmentAvailableEvent(this, environment, args));
            sources = this.getSources();
            Assert.notEmpty(sources, (String)"Sources must not be empty");
            if (this.showBanner) {
                this.printBanner();
            }
            this.registerListeners(multicaster, sources);
            context = this.createApplicationContext();
            this.registerApplicationEventMulticaster(context, multicaster);
            context.registerShutdownHook();
            context.setEnvironment(environment);
            this.postProcessApplicationContext(context);
            this.applyInitializers(context);
            if (this.logStartupInfo) {
                this.logStartupInfo(context.getParent() == null);
            }
            this.load((ApplicationContext)context, sources.toArray(new Object[sources.size()]));
            multicaster.multicastEvent((ApplicationEvent)new SpringApplicationBeforeRefreshEvent(this, context, args));
            this.refresh((ApplicationContext)context);
            stopWatch.stop();
            if (this.logStartupInfo) {
                new StartupInfoLogger(this.mainApplicationClass).logStarted(this.getApplicationLog(), stopWatch);
            }
            this.afterRefresh(context, args);
            return context;
        }
        catch (RuntimeException ex) {
            this.handleError(context, multicaster, ex, args);
            throw ex;
        }
        catch (Error ex) {
            this.handleError(context, multicaster, ex, args);
            throw ex;
        }
    }

    protected void handleError(ConfigurableApplicationContext context, ApplicationEventMulticaster multicaster, Throwable ex, String ... args) {
        multicaster.multicastEvent((ApplicationEvent)new SpringApplicationErrorEvent(this, context, args, ex));
        if (context != null) {
            context.close();
        }
    }

    private void registerListeners(ApplicationEventMulticaster multicaster, Set<Object> sources) {
        for (Object object : sources) {
            if (object instanceof ApplicationListener) {
                multicaster.addApplicationListener((ApplicationListener)object);
            }
            if (!(object instanceof ApplicationContextInitializer)) continue;
            this.addInitializers((ApplicationContextInitializer)object);
        }
    }

    private void registerApplicationEventMulticaster(ConfigurableApplicationContext context, ApplicationEventMulticaster multicaster) {
        context.getBeanFactory().registerSingleton("applicationEventMulticaster", (Object)multicaster);
        if (multicaster instanceof BeanFactoryAware) {
            ((BeanFactoryAware)multicaster).setBeanFactory((BeanFactory)context.getBeanFactory());
        }
    }

    private ApplicationEventMulticaster createApplicationEventMulticaster() {
        SpringApplicationEventMulticaster multicaster = new SpringApplicationEventMulticaster();
        for (ApplicationListener<?> listener : this.getListeners()) {
            multicaster.addApplicationListener(listener);
        }
        return multicaster;
    }

    private void afterRefresh(ConfigurableApplicationContext context, String[] args) {
        this.runCommandLineRunners((ApplicationContext)context, args);
    }

    private ConfigurableEnvironment getOrCreateEnvironment() {
        if (this.environment != null) {
            return this.environment;
        }
        if (this.webEnvironment) {
            return new StandardServletEnvironment();
        }
        return new StandardEnvironment();
    }

    protected void addPropertySources(ConfigurableEnvironment environment, String[] args) {
        MutablePropertySources sources = environment.getPropertySources();
        if (this.defaultProperties != null && !this.defaultProperties.isEmpty()) {
            sources.addLast((PropertySource)new MapPropertySource("defaultProperties", this.defaultProperties));
        }
        if (this.addCommandLineProperties && args.length > 0) {
            String name = "commandLineArgs";
            if (sources.contains(name)) {
                PropertySource source = sources.get(name);
                CompositePropertySource composite = new CompositePropertySource(name);
                composite.addPropertySource((PropertySource)new SimpleCommandLinePropertySource(name + "-" + args.hashCode(), args));
                composite.addPropertySource(source);
                sources.replace(name, (PropertySource)composite);
            } else {
                sources.addFirst((PropertySource)new SimpleCommandLinePropertySource(args));
            }
        }
    }

    protected void printBanner() {
        Banner.write(System.out);
    }

    protected void applyInitializers(ConfigurableApplicationContext context) {
        for (ApplicationContextInitializer<?> initializer : this.getInitializers()) {
            Class requiredType = GenericTypeResolver.resolveTypeArgument(initializer.getClass(), ApplicationContextInitializer.class);
            Assert.isInstanceOf((Class)requiredType, (Object)context, (String)"Unable to call initializer.");
            initializer.initialize(context);
        }
    }

    protected void logStartupInfo(boolean isRoot) {
        if (isRoot) {
            new StartupInfoLogger(this.mainApplicationClass).logStarting(this.getApplicationLog());
        }
    }

    protected Log getApplicationLog() {
        if (this.mainApplicationClass == null) {
            return this.log;
        }
        return LogFactory.getLog(this.mainApplicationClass);
    }

    protected ConfigurableApplicationContext createApplicationContext() {
        Class<Object> contextClass = this.applicationContextClass;
        if (contextClass == null) {
            try {
                contextClass = Class.forName(this.webEnvironment ? DEFAULT_WEB_CONTEXT_CLASS : DEFAULT_CONTEXT_CLASS);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Unable create a default ApplicationContext, please specify an ApplicationContextClass", ex);
            }
        }
        return (ConfigurableApplicationContext)BeanUtils.instantiate(contextClass);
    }

    protected void postProcessApplicationContext(ConfigurableApplicationContext context) {
        if (this.webEnvironment && context instanceof ConfigurableWebApplicationContext) {
            ConfigurableWebApplicationContext configurableContext = (ConfigurableWebApplicationContext)context;
            if (this.beanNameGenerator != null) {
                configurableContext.getBeanFactory().registerSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator", (Object)this.beanNameGenerator);
            }
        }
        if (this.resourceLoader != null) {
            if (context instanceof GenericApplicationContext) {
                ((GenericApplicationContext)context).setResourceLoader(this.resourceLoader);
            }
            if (context instanceof DefaultResourceLoader) {
                ((DefaultResourceLoader)context).setClassLoader(this.resourceLoader.getClassLoader());
            }
        }
    }

    protected void load(ApplicationContext context, Object[] sources) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading source " + StringUtils.arrayToCommaDelimitedString((Object[])sources)));
        }
        BeanDefinitionLoader loader = this.createBeanDefinitionLoader(this.getBeanDefinitionRegistry(context), sources);
        if (this.beanNameGenerator != null) {
            loader.setBeanNameGenerator(this.beanNameGenerator);
        }
        if (this.resourceLoader != null) {
            loader.setResourceLoader(this.resourceLoader);
        }
        if (this.environment != null) {
            loader.setEnvironment(this.environment);
        }
        loader.load();
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public ClassLoader getClassLoader() {
        if (this.resourceLoader != null) {
            return this.resourceLoader.getClassLoader();
        }
        return ClassUtils.getDefaultClassLoader();
    }

    private BeanDefinitionRegistry getBeanDefinitionRegistry(ApplicationContext context) {
        if (context instanceof BeanDefinitionRegistry) {
            return (BeanDefinitionRegistry)context;
        }
        if (context instanceof AbstractApplicationContext) {
            return (BeanDefinitionRegistry)((AbstractApplicationContext)context).getBeanFactory();
        }
        throw new IllegalStateException("Could not locate BeanDefinitionRegistry");
    }

    protected BeanDefinitionLoader createBeanDefinitionLoader(BeanDefinitionRegistry registry, Object[] sources) {
        return new BeanDefinitionLoader(registry, sources);
    }

    private void runCommandLineRunners(ApplicationContext context, String ... args) {
        ArrayList runners = new ArrayList(context.getBeansOfType(CommandLineRunner.class).values());
        AnnotationAwareOrderComparator.sort(runners);
        for (CommandLineRunner runner : runners) {
            try {
                runner.run(args);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to execute CommandLineRunner", ex);
            }
        }
    }

    protected void refresh(ApplicationContext applicationContext) {
        Assert.isInstanceOf(AbstractApplicationContext.class, (Object)applicationContext);
        ((AbstractApplicationContext)applicationContext).refresh();
    }

    public void setMainApplicationClass(Class<?> mainApplicationClass) {
        this.mainApplicationClass = mainApplicationClass;
    }

    public void setWebEnvironment(boolean webEnvironment) {
        this.webEnvironment = webEnvironment;
    }

    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public void setShowBanner(boolean showBanner) {
        this.showBanner = showBanner;
    }

    public void setLogStartupInfo(boolean logStartupInfo) {
        this.logStartupInfo = logStartupInfo;
    }

    public void setAddCommandLineProperties(boolean addCommandLineProperties) {
        this.addCommandLineProperties = addCommandLineProperties;
    }

    public void setDefaultProperties(Map<String, Object> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public void setDefaultProperties(Properties defaultProperties) {
        this.defaultProperties = new HashMap<String, Object>();
        for (Object key : Collections.list(defaultProperties.propertyNames())) {
            this.defaultProperties.put((String)key, defaultProperties.get(key));
        }
    }

    public void setAdditionalProfiles(Collection<String> profiles) {
        this.profiles = new LinkedHashSet<String>(profiles);
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator;
    }

    public void setEnvironment(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public Set<Object> getSources() {
        return this.sources;
    }

    public void setSources(Set<Object> sources) {
        Assert.notNull(sources, (String)"Sources must not be null");
        this.sources.addAll(sources);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, (String)"ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
    }

    public void setApplicationContextClass(Class<? extends ConfigurableApplicationContext> applicationContextClass) {
        this.applicationContextClass = applicationContextClass;
        if (!WebApplicationContext.class.isAssignableFrom(applicationContextClass)) {
            this.webEnvironment = false;
        }
    }

    public void setInitializers(Collection<? extends ApplicationContextInitializer<?>> initializers) {
        this.initializers = new LinkedHashSet(initializers);
        for (ApplicationContextInitializer<?> initializer : initializers) {
            if (!(initializer instanceof ApplicationListener)) continue;
            this.listeners.add((ApplicationListener)initializer);
        }
    }

    public void addInitializers(ApplicationContextInitializer<?> ... initializers) {
        this.initializers.addAll(Arrays.asList(initializers));
        for (ApplicationContextInitializer<?> initializer : initializers) {
            if (!(initializer instanceof ApplicationListener)) continue;
            this.listeners.add((ApplicationListener)initializer);
        }
    }

    public Set<ApplicationContextInitializer<?>> getInitializers() {
        return Collections.unmodifiableSet(this.initializers);
    }

    public void setListeners(Collection<? extends ApplicationListener<?>> listeners) {
        this.listeners = new LinkedHashSet(listeners);
        for (ApplicationListener<?> listener : listeners) {
            if (!(listener instanceof ApplicationContextInitializer)) continue;
            this.initializers.add((ApplicationContextInitializer)listener);
        }
    }

    public void addListeners(ApplicationListener<?> ... listeners) {
        this.listeners.addAll(Arrays.asList(listeners));
        for (ApplicationListener<?> listener : listeners) {
            if (!(listener instanceof ApplicationContextInitializer)) continue;
            this.initializers.add((ApplicationContextInitializer)listener);
        }
    }

    public Set<ApplicationListener<?>> getListeners() {
        return Collections.unmodifiableSet(new LinkedHashSet(this.listeners));
    }

    public static ConfigurableApplicationContext run(Object source, String ... args) {
        return SpringApplication.run(new Object[]{source}, args);
    }

    public static ConfigurableApplicationContext run(Object[] sources, String[] args) {
        return new SpringApplication(sources).run(args);
    }

    public static void main(String[] args) throws Exception {
        SpringApplication.run(new Object[0], args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int exit(ApplicationContext context, ExitCodeGenerator ... exitCodeGenerators) {
        int exitCode = 0;
        try {
            try {
                ArrayList<ExitCodeGenerator> generators = new ArrayList<ExitCodeGenerator>();
                generators.addAll(Arrays.asList(exitCodeGenerators));
                generators.addAll(context.getBeansOfType(ExitCodeGenerator.class).values());
                exitCode = SpringApplication.getExitCode(generators);
            }
            finally {
                SpringApplication.close(context);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            exitCode = exitCode == 0 ? 1 : exitCode;
        }
        return exitCode;
    }

    private static int getExitCode(List<ExitCodeGenerator> exitCodeGenerators) {
        int exitCode = 0;
        for (ExitCodeGenerator exitCodeGenerator : exitCodeGenerators) {
            try {
                int value = exitCodeGenerator.getExitCode();
                if ((value <= 0 || value <= exitCode) && (value >= 0 || value >= exitCode)) continue;
                exitCode = value;
            }
            catch (Exception ex) {
                exitCode = exitCode == 0 ? 1 : exitCode;
                ex.printStackTrace();
            }
        }
        return exitCode;
    }

    private static void close(ApplicationContext context) {
        if (context instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext closable = (ConfigurableApplicationContext)context;
            closable.close();
        }
    }

    private static class SpringApplicationEventMulticaster
    extends SimpleApplicationEventMulticaster
    implements ApplicationEventPublisher {
        private SpringApplicationEventMulticaster() {
        }

        public void publishEvent(ApplicationEvent event) {
            this.multicastEvent(event);
        }

        protected Collection<ApplicationListener<?>> getApplicationListeners(ApplicationEvent event) {
            ArrayList listeners = new ArrayList(super.getApplicationListeners(event));
            if (event instanceof SpringApplicationErrorEvent) {
                Collections.reverse(listeners);
            }
            return listeners;
        }

        public void addApplicationListener(ApplicationListener<?> listener) {
            super.addApplicationListener(listener);
            if (listener instanceof ApplicationEventPublisherAware) {
                ((ApplicationEventPublisherAware)listener).setApplicationEventPublisher((ApplicationEventPublisher)this);
            }
        }
    }
}

