/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.boot.config.PropertiesPropertySourceLoader;
import org.springframework.boot.config.PropertySourceLoader;
import org.springframework.boot.config.YamlPropertySourceLoader;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesHolder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

public class ConfigurationPropertiesBindingPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
ResourceLoaderAware,
EnvironmentAware,
ApplicationContextAware,
InitializingBean,
DisposableBean,
Ordered {
    public static final String VALIDATOR_BEAN_NAME = "configurationPropertiesValidator";
    private static final String[] VALIDATOR_CLASSES = new String[]{"javax.validation.Validator", "javax.validation.ValidatorFactory"};
    private PropertySources propertySources;
    private Validator validator;
    private boolean ownedValidator = false;
    private ConversionService conversionService;
    private DefaultConversionService defaultConversionService = new DefaultConversionService();
    private BeanFactory beanFactory;
    private boolean initialized = false;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private Environment environment = new StandardEnvironment();
    private ApplicationContext applicationContext;
    private int order = Integer.MIN_VALUE;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setPropertySources(PropertySources propertySources) {
        this.propertySources = propertySources;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.propertySources == null) {
            this.propertySources = this.deducePropertySources();
        }
        if (this.validator == null) {
            this.validator = this.getOptionalBean(VALIDATOR_BEAN_NAME, Validator.class);
            if (this.validator == null && this.isJsr303Present()) {
                this.validator = new Jsr303ValidatorFactory().run(this.applicationContext);
                this.ownedValidator = true;
            }
        }
        if (this.conversionService == null) {
            this.conversionService = this.getOptionalBean("conversionService", ConversionService.class);
        }
    }

    private boolean isJsr303Present() {
        for (String validatorClass : VALIDATOR_CLASSES) {
            if (ClassUtils.isPresent((String)validatorClass, (ClassLoader)this.applicationContext.getClassLoader())) continue;
            return false;
        }
        return true;
    }

    public void destroy() throws Exception {
        if (this.ownedValidator) {
            ((DisposableBean)this.validator).destroy();
        }
    }

    private PropertySources deducePropertySources() {
        try {
            PropertySourcesPlaceholderConfigurer configurer = (PropertySourcesPlaceholderConfigurer)this.beanFactory.getBean(PropertySourcesPlaceholderConfigurer.class);
            return this.extractPropertySources(configurer);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            if (this.environment instanceof ConfigurableEnvironment) {
                return this.flattenPropertySources((PropertySources)((ConfigurableEnvironment)this.environment).getPropertySources());
            }
            return new MutablePropertySources();
        }
    }

    private <T> T getOptionalBean(String name, Class<T> type) {
        try {
            return (T)this.beanFactory.getBean(name, type);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    private PropertySources extractPropertySources(PropertySourcesPlaceholderConfigurer configurer) {
        PropertySources propertySources = configurer.getAppliedPropertySources();
        return this.flattenPropertySources(propertySources);
    }

    private PropertySources flattenPropertySources(PropertySources propertySources) {
        MutablePropertySources result = new MutablePropertySources();
        for (PropertySource propertySource : propertySources) {
            this.flattenPropertySources(propertySource, result);
        }
        return result;
    }

    private void flattenPropertySources(PropertySource<?> propertySource, MutablePropertySources result) {
        Object source = propertySource.getSource();
        if (source instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment environment = (ConfigurableEnvironment)source;
            for (PropertySource childSource : environment.getPropertySources()) {
                this.flattenPropertySources(childSource, result);
            }
        } else {
            result.addLast(propertySource);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        ConfigurationProperties annotation = (ConfigurationProperties)AnnotationUtils.findAnnotation(bean.getClass(), ConfigurationProperties.class);
        if (annotation != null || bean instanceof ConfigurationPropertiesHolder) {
            this.postProcessAfterInitialization(bean, beanName, annotation);
        }
        return bean;
    }

    private void postProcessAfterInitialization(Object bean, String beanName, ConfigurationProperties annotation) {
        Object target = bean instanceof ConfigurationPropertiesHolder ? ((ConfigurationPropertiesHolder)bean).getTarget() : bean;
        PropertiesConfigurationFactory<Object> factory = new PropertiesConfigurationFactory<Object>(target);
        if (annotation != null && annotation.path().length != 0) {
            factory.setPropertySources(this.loadPropertySources(annotation.path()));
        } else {
            factory.setPropertySources(this.propertySources);
        }
        factory.setValidator(this.validator);
        factory.setConversionService(this.conversionService == null ? this.getDefaultConversionService() : this.conversionService);
        if (annotation != null) {
            String targetName;
            factory.setIgnoreInvalidFields(annotation.ignoreInvalidFields());
            factory.setIgnoreUnknownFields(annotation.ignoreUnknownFields());
            String string = targetName = StringUtils.hasLength((String)annotation.value()) ? annotation.value() : annotation.name();
            if (StringUtils.hasLength((String)targetName)) {
                factory.setTargetName(targetName);
            }
        }
        try {
            factory.bindPropertiesToTarget();
        }
        catch (Exception ex) {
            throw new BeanCreationException(beanName, "Could not bind properties", (Throwable)ex);
        }
    }

    private PropertySources loadPropertySources(String[] path) {
        MutablePropertySources propertySources = new MutablePropertySources();
        PropertySourceLoader[] loaders = new PropertySourceLoader[]{new PropertiesPropertySourceLoader(), YamlPropertySourceLoader.springProfileAwareLoader(this.environment.getActiveProfiles())};
        for (String location : path) {
            Resource resource = this.resourceLoader.getResource(location = this.environment.resolvePlaceholders(location));
            if (resource == null || !resource.exists()) continue;
            for (PropertySourceLoader loader : loaders) {
                if (!loader.supports(resource)) continue;
                PropertySource<?> propertySource = loader.load(resource);
                propertySources.addFirst(propertySource);
            }
        }
        return propertySources;
    }

    private ConversionService getDefaultConversionService() {
        if (!this.initialized && this.beanFactory instanceof ListableBeanFactory) {
            for (Converter converter : ((ListableBeanFactory)this.beanFactory).getBeansOfType(Converter.class).values()) {
                this.defaultConversionService.addConverter(converter);
            }
        }
        return this.defaultConversionService;
    }

    private static class Jsr303ValidatorFactory {
        private Jsr303ValidatorFactory() {
        }

        public Validator run(ApplicationContext applicationContext) {
            LocalValidatorFactoryBean validator = new LocalValidatorFactoryBean();
            validator.setApplicationContext(applicationContext);
            validator.afterPropertiesSet();
            return validator;
        }
    }
}

