/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.properties;

import java.io.File;
import java.net.InetAddress;
import javax.validation.constraints.NotNull;
import org.apache.catalina.Context;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.RemoteIpValve;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(name="server", ignoreUnknownFields=false)
public class ServerProperties
implements EmbeddedServletContainerCustomizer {
    private Integer port;
    private InetAddress address;
    private Integer sessionTimeout;
    @NotNull
    private String contextPath = "";
    private Tomcat tomcat = new Tomcat();

    public Tomcat getTomcat() {
        return this.tomcat;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setLoader(String value) {
    }

    @Override
    public void customize(ConfigurableEmbeddedServletContainerFactory factory) {
        if (this.getPort() != null) {
            factory.setPort(this.getPort());
        }
        if (this.getAddress() != null) {
            factory.setAddress(this.getAddress());
        }
        if (this.getContextPath() != null) {
            factory.setContextPath(this.getContextPath());
        }
        if (this.getSessionTimeout() != null) {
            factory.setSessionTimeout(this.getSessionTimeout());
        }
        if (factory instanceof TomcatEmbeddedServletContainerFactory) {
            this.getTomcat().customizeTomcat((TomcatEmbeddedServletContainerFactory)factory);
        }
    }

    public static class Tomcat {
        private String accessLogPattern;
        private boolean accessLogEnabled = false;
        private String protocolHeader = "x-forwarded-proto";
        private String remoteIpHeader = "x-forwarded-for";
        private File basedir;
        private int backgroundProcessorDelay = 30;
        private int maxThreads = 0;

        public int getMaxThreads() {
            return this.maxThreads;
        }

        public void setMaxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
        }

        public boolean getAccessLogEnabled() {
            return this.accessLogEnabled;
        }

        public void setAccessLogEnabled(boolean accessLogEnabled) {
            this.accessLogEnabled = accessLogEnabled;
        }

        public int getBackgroundProcessorDelay() {
            return this.backgroundProcessorDelay;
        }

        public void setBackgroundProcessorDelay(int backgroundProcessorDelay) {
            this.backgroundProcessorDelay = backgroundProcessorDelay;
        }

        public File getBasedir() {
            return this.basedir;
        }

        public void setBasedir(File basedir) {
            this.basedir = basedir;
        }

        public String getAccessLogPattern() {
            return this.accessLogPattern;
        }

        public void setAccessLogPattern(String accessLogPattern) {
            this.accessLogPattern = accessLogPattern;
        }

        public String getProtocolHeader() {
            return this.protocolHeader;
        }

        public void setProtocolHeader(String protocolHeader) {
            this.protocolHeader = protocolHeader;
        }

        public String getRemoteIpHeader() {
            return this.remoteIpHeader;
        }

        public void setRemoteIpHeader(String remoteIpHeader) {
            this.remoteIpHeader = remoteIpHeader;
        }

        void customizeTomcat(TomcatEmbeddedServletContainerFactory factory) {
            RemoteIpValve valve;
            if (this.getBasedir() != null) {
                factory.setBaseDirectory(this.getBasedir());
            }
            factory.addContextCustomizers(new TomcatContextCustomizer(){

                @Override
                public void customize(Context context) {
                    context.setBackgroundProcessorDelay(Tomcat.this.backgroundProcessorDelay);
                }
            });
            String remoteIpHeader = this.getRemoteIpHeader();
            String protocolHeader = this.getProtocolHeader();
            if (StringUtils.hasText((String)remoteIpHeader) || StringUtils.hasText((String)protocolHeader)) {
                valve = new RemoteIpValve();
                valve.setRemoteIpHeader(remoteIpHeader);
                valve.setProtocolHeader(protocolHeader);
                factory.addContextValves(new Valve[]{valve});
            }
            if (this.maxThreads > 0) {
                factory.addConnectorCustomizers(new TomcatConnectorCustomizer(){

                    @Override
                    public void customize(Connector connector) {
                        ProtocolHandler handler = connector.getProtocolHandler();
                        if (handler instanceof AbstractProtocol) {
                            AbstractProtocol protocol = (AbstractProtocol)handler;
                            protocol.setMaxThreads(Tomcat.this.maxThreads);
                        }
                    }
                });
            }
            if (this.accessLogEnabled) {
                valve = new AccessLogValve();
                String accessLogPattern = this.getAccessLogPattern();
                if (accessLogPattern != null) {
                    valve.setPattern(accessLogPattern);
                } else {
                    valve.setPattern("common");
                }
                valve.setSuffix(".log");
                factory.addContextValves(new Valve[]{valve});
            }
        }
    }
}

