/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.config;

import java.util.Properties;
import java.util.Set;
import org.springframework.boot.config.YamlProcessor;
import org.springframework.util.StringUtils;

public class ArrayDocumentMatcher
implements YamlProcessor.DocumentMatcher {
    private String key;
    private String[] patterns;

    public ArrayDocumentMatcher(String key, String ... patterns) {
        this.key = key;
        this.patterns = patterns;
    }

    @Override
    public YamlProcessor.MatchStatus matches(Properties properties) {
        if (!properties.containsKey(this.key)) {
            return YamlProcessor.MatchStatus.ABSTAIN;
        }
        Set values = StringUtils.commaDelimitedListToSet((String)properties.getProperty(this.key));
        for (String pattern : this.patterns) {
            for (String value : values) {
                if (!value.matches(pattern)) continue;
                return YamlProcessor.MatchStatus.FOUND;
            }
        }
        return YamlProcessor.MatchStatus.NOT_FOUND;
    }
}

