/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.PropertySources;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

public class PropertiesConfigurationFactory<T>
implements FactoryBean<T>,
MessageSourceAware,
InitializingBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private boolean ignoreUnknownFields = true;
    private boolean ignoreInvalidFields;
    private boolean exceptionIfInvalid = true;
    private Properties properties;
    private PropertySources propertySources;
    private T target;
    private Validator validator;
    private MessageSource messageSource;
    private boolean hasBeenBound = false;
    private String targetName;
    private ConversionService conversionService;

    public PropertiesConfigurationFactory(T target) {
        Assert.notNull(target);
        this.target = target;
    }

    public PropertiesConfigurationFactory(Class<?> type) {
        Assert.notNull(type);
        this.target = BeanUtils.instantiate(type);
    }

    public void setIgnoreUnknownFields(boolean ignoreUnknownFields) {
        this.ignoreUnknownFields = ignoreUnknownFields;
    }

    public void setIgnoreInvalidFields(boolean ignoreInvalidFields) {
        this.ignoreInvalidFields = ignoreInvalidFields;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setPropertySources(PropertySources propertySources) {
        this.propertySources = propertySources;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setExceptionIfInvalid(boolean exceptionIfInvalid) {
        this.exceptionIfInvalid = exceptionIfInvalid;
    }

    public void afterPropertiesSet() throws Exception {
        this.bindPropertiesToTarget();
    }

    public Class<?> getObjectType() {
        if (this.target == null) {
            return Object.class;
        }
        return this.target.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public T getObject() throws Exception {
        if (!this.hasBeenBound) {
            this.bindPropertiesToTarget();
        }
        return this.target;
    }

    public void bindPropertiesToTarget() throws BindException {
        Assert.state((this.properties != null || this.propertySources != null ? 1 : 0) != 0, (String)"Properties or propertySources should not be null");
        try {
            if (this.logger.isTraceEnabled()) {
                if (this.properties != null) {
                    this.logger.trace((Object)("Properties:\n" + this.properties));
                } else {
                    this.logger.trace((Object)("Property Sources: " + this.propertySources));
                }
            }
            this.hasBeenBound = true;
            this.doBindPropertiesToTarget();
        }
        catch (BindException ex) {
            if (this.exceptionIfInvalid) {
                throw ex;
            }
            this.logger.error((Object)"Failed to load Properties validation bean. Your Properties may be invalid.", (Throwable)ex);
        }
    }

    private void doBindPropertiesToTarget() throws BindException {
        RelaxedDataBinder dataBinder;
        RelaxedDataBinder relaxedDataBinder = dataBinder = this.targetName != null ? new RelaxedDataBinder(this.target, this.targetName) : new RelaxedDataBinder(this.target);
        if (this.validator != null) {
            dataBinder.setValidator(this.validator);
        }
        if (this.conversionService != null) {
            dataBinder.setConversionService(this.conversionService);
        }
        dataBinder.setIgnoreInvalidFields(this.ignoreInvalidFields);
        dataBinder.setIgnoreUnknownFields(this.ignoreUnknownFields);
        this.customizeBinder(dataBinder);
        Object propertyValues = this.properties != null ? new MutablePropertyValues((Map)this.properties) : new PropertySourcesPropertyValues(this.propertySources);
        dataBinder.bind((PropertyValues)propertyValues);
        if (this.validator != null) {
            this.validate(dataBinder);
        }
    }

    private void validate(RelaxedDataBinder dataBinder) throws BindException {
        dataBinder.validate();
        BindingResult errors = dataBinder.getBindingResult();
        if (errors.hasErrors()) {
            this.logger.error((Object)"Properties configuration failed validation");
            for (ObjectError error : errors.getAllErrors()) {
                this.logger.error((Object)(this.messageSource != null ? this.messageSource.getMessage((MessageSourceResolvable)error, Locale.getDefault()) + " (" + error + ")" : error));
            }
            if (this.exceptionIfInvalid) {
                throw new BindException(errors);
            }
        }
    }

    protected void customizeBinder(DataBinder dataBinder) {
    }
}

